/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext;

import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pbjar.jxlayer.plaf.ext.MouseEventUI;
import org.pbjar.jxlayer.plaf.ext.transform.DefaultTransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformLayout;
import org.pbjar.jxlayer.plaf.ext.transform.TransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformRPMAnnotation;
import org.pbjar.jxlayer.plaf.ext.transform.TransformRPMFallBack;
import org.pbjar.jxlayer.plaf.ext.transform.TransformUtils;
import org.pbjar.jxlayer.repaint.RepaintManagerProvider;
import org.pbjar.jxlayer.repaint.RepaintManagerUtils;

public class TransformUI
extends MouseEventUI<JComponent> {
    public static final String BUFFERED_REPAINT_FLAG = "darklaf.useBufferedRepaintManager";
    private static final String EXPORTS_FLAG = "--add-exports java.desktop/com.sun.java.swing=ALL-UNNAMED";
    private static final LayoutManager transformLayout;
    private static final String KEY_VIEW = "view";
    private static final boolean delegatePossible;
    private static final RepaintManager wrappedManager;
    private static final Logger LOGGER;
    private static MethodHandle setDelegateRepaintManagerMethod;
    private final ChangeListener changeListener = e -> this.revalidateLayer();
    private final RepaintManagerProvider rpmProvider = new RepaintManagerProvider(){

        @Override
        public RepaintManager createWrappedRepaintManager(RepaintManager delegate) {
            return new TransformRPMFallBack(delegate);
        }

        @Override
        public boolean isAdequate(RepaintManager manager) {
            return manager.getClass().isAnnotationPresent(TransformRPMAnnotation.class);
        }
    };
    private final Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    private final Set<JComponent> originalDoubleBuffered = new HashSet<JComponent>();
    private JComponent view;
    private final PropertyChangeListener viewChangeListener = evt -> this.setView((JComponent)evt.getNewValue());
    private TransformModel transformModel;
    private LayoutManager originalLayout;

    public TransformUI() {
        this(new DefaultTransformModel());
    }

    public TransformUI(TransformModel model) {
        this.setModel(model);
    }

    private void revalidateLayer() {
        JLayer installedLayer = this.getInstalledLayer();
        if (installedLayer != null) {
            installedLayer.revalidate();
            installedLayer.repaint();
        }
    }

    public static void prepareForJTextComponent() {
        System.setProperty("i18n", Boolean.TRUE.toString());
    }

    public void addRenderingHint(RenderingHints.Key key, Object value) {
        this.renderingHints.put(key, value);
    }

    public void addRenderingHints(Map<RenderingHints.Key, Object> hints) {
        this.renderingHints.putAll(hints);
    }

    public final TransformModel getModel() {
        return this.transformModel;
    }

    public final void setModel(TransformModel transformModel) throws NullPointerException {
        if (transformModel == null) {
            throw new NullPointerException("The TransformModel may not be null");
        }
        if (this.transformModel != null) {
            this.transformModel.removeChangeListener(this.changeListener);
        }
        this.transformModel = transformModel;
        this.transformModel.addChangeListener(this.changeListener);
        this.revalidateLayer();
    }

    public AffineTransform getPreferredTransform(Dimension size, JLayer<? extends JComponent> layer) {
        return this.transformModel != null ? this.transformModel.getPreferredTransform(size, layer) : new AffineTransform();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        JLayer installedLayer = this.getInstalledLayer();
        this.originalLayout = installedLayer.getLayout();
        installedLayer.addPropertyChangeListener(KEY_VIEW, this.viewChangeListener);
        this.setLayoutManager(transformLayout);
        this.setView((JComponent)installedLayer.getView());
        if (!delegatePossible) {
            String warningMessage = "Using a fallback method for the TransformUI repaint manager. This will result in flickering during resizing\nConsider adding\n       -Ddarklaf.useBufferedRepaintManager=true\n       --add-exports java.desktop/com.sun.java.swing=ALL-UNNAMED\nto your startup parameters or providing a fix for this issue";
            LOGGER.warning(warningMessage);
            RepaintManagerUtils.ensureRepaintManagerSet(installedLayer, this.rpmProvider);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        JLayer installedLayer = this.getInstalledLayer();
        Objects.requireNonNull(installedLayer).removePropertyChangeListener(KEY_VIEW, this.viewChangeListener);
        installedLayer.setLayout(this.originalLayout);
        this.setView(null);
        super.uninstallUI(c);
    }

    private void setView(JComponent view) {
        if (delegatePossible && this.view != null) {
            try {
                setDelegateRepaintManagerMethod.invokeExact(this.view, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.view = view;
        if (delegatePossible && this.view != null) {
            try {
                setDelegateRepaintManagerMethod.invokeExact(this.view, wrappedManager);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setDirty(true);
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> hints) {
        this.renderingHints.clear();
        if (hints != null) {
            this.renderingHints.putAll(hints);
        }
    }

    public final Rectangle transform(Rectangle rect, JLayer<? extends JComponent> layer) {
        AffineTransform at = this.getTransform(layer);
        if (at == null) {
            return rect;
        }
        Area area = new Area(rect);
        area.transform(at);
        return area.getBounds();
    }

    @Override
    public void updateUI(JLayer<? extends JComponent> layer) {
        this.setDirty(true);
    }

    private void setToNoDoubleBuffering(Component component) {
        JComponent comp;
        if (component instanceof JComponent && (comp = (JComponent)component).isDoubleBuffered()) {
            this.originalDoubleBuffered.add(comp);
            comp.setDoubleBuffered(false);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int index = 0; index < container.getComponentCount(); ++index) {
                this.setToNoDoubleBuffering(container.getComponent(index));
            }
        }
    }

    @Override
    protected final void paintLayer(Graphics2D g2, JLayer<? extends JComponent> layer) {
        JComponent view = layer.getView();
        if (view != null && (view.getX() < 0 || view.getY() < 0)) {
            this.setToNoDoubleBuffering(view);
            g2.translate(view.getX(), view.getY());
            view.paint(g2);
            for (JComponent comp : this.originalDoubleBuffered) {
                comp.setDoubleBuffered(true);
            }
            this.originalDoubleBuffered.clear();
            return;
        }
        super.paintLayer(g2, layer);
    }

    @Override
    protected final AffineTransform getTransform(JLayer<? extends JComponent> layer) {
        return this.transformModel != null ? this.transformModel.getTransform(layer) : new AffineTransform();
    }

    @Override
    protected Map<RenderingHints.Key, Object> getRenderingHints(JLayer<? extends JComponent> layer) {
        return this.renderingHints;
    }

    static {
        boolean value;
        transformLayout = new TransformLayout();
        wrappedManager = new TransformRepaintManager();
        LOGGER = LogUtil.getDetachedLogger(TransformUI.class);
        boolean bufferFlag = PropertyUtil.getSystemFlag(BUFFERED_REPAINT_FLAG, false);
        try {
            if (!SystemInfo.isJava16OrGreater || bufferFlag) {
                Class<?> swingUtilities3 = Class.forName("com.sun.java.swing.SwingUtilities3");
                setDelegateRepaintManagerMethod = MethodHandles.lookup().findStatic(swingUtilities3, "setDelegateRepaintManager", MethodType.methodType(Void.TYPE, JComponent.class, RepaintManager.class));
                value = true;
            } else {
                value = false;
            }
        }
        catch (Throwable t) {
            if (bufferFlag) {
                LOGGER.log(Level.SEVERE, "For darklaf.useBufferedRepaintManager to work you need to start with --add-exports java.desktop/com.sun.java.swing=ALL-UNNAMED", t);
            }
            value = false;
        }
        delegatePossible = value;
        LOGGER.info("Java " + System.getProperty("java.version") + " " + System.getProperty("java.vm.version") + (delegatePossible ? ": RepaintManager delegate facility for JavaFX will be used." : ": RepaintManager.setCurrentManager() will be used."));
    }

    protected static final class TransformRepaintManager
    extends RepaintManager {
        private TransformRepaintManager() {
        }

        @Override
        public void addInvalidComponent(JComponent invalidComponent) {
            JLayer<? extends JComponent> layer = TransformUtils.findTransformJLayer(invalidComponent);
            RepaintManager.currentManager(layer).addInvalidComponent(layer);
        }

        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            if (c.isShowing()) {
                JLayer<? extends JComponent> layer = Objects.requireNonNull(TransformUtils.findTransformJLayer(c));
                TransformUI ui = (TransformUI)layer.getUI();
                Point point = c.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, layer);
                Rectangle transformPortRegion = ui.transform(new Rectangle(x + point.x, y + point.y, w, h), layer);
                RepaintManager.currentManager(layer).addDirtyRegion(layer, transformPortRegion.x, transformPortRegion.y, transformPortRegion.width, transformPortRegion.height);
            }
        }
    }
}

