/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.graphics.Animator;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.graphics.StringPainter;
import com.github.weisj.darklaf.ui.tooltip.AlignableTooltipBorder;
import com.github.weisj.darklaf.ui.tooltip.DarkDefaultToolTipBorder;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipBorder;
import com.github.weisj.darklaf.ui.tooltip.ToolTipConstants;
import com.github.weisj.darklaf.ui.tooltip.ToolTipUtil;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class DarkToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener,
HierarchyListener,
ToolTipConstants {
    protected static final float MAX_ALPHA = 1.0f;
    protected static final float MIN_ALPHA = 0.1f;
    protected final MouseListener exitListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            boolean inside = DarkToolTipUI.this.isInside(e);
            if (!inside) {
                ToolTipManager.sharedInstance().mouseExited(new MouseEvent(DarkToolTipUI.this.toolTip.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), Integer.MIN_VALUE, Integer.MIN_VALUE, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }
        }
    };
    protected final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getButton() == 1) {
                return;
            }
            Point p = e.getPoint();
            JComponent c = DarkToolTipUI.this.toolTip.getComponent();
            if (p.x == ((Component)c).getWidth()) {
                --p.x;
            }
            if (p.y == ((Component)c).getHeight()) {
                --p.y;
            }
            p.x = Math.max(p.x, 0);
            p.y = Math.max(p.y, 0);
            ToolTipManager.sharedInstance().mouseEntered(new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiersEx(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DarkToolTipUI.this.exitListener.mouseExited(e);
        }
    };
    protected final PropertyChangeListener componentPropertyChaneListener = e -> {
        if ("JToolTip.style".equals(e.getPropertyName())) {
            this.updateStyle();
        }
    };
    protected Animator fadeAnimator;
    protected float alpha = 0.0f;
    protected JToolTip toolTip;
    protected ToolTipStyle style;
    private boolean animationScheduled;
    protected String effectiveTipText;

    public static ComponentUI createUI(JComponent c) {
        return new DarkToolTipUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.toolTip = (JToolTip)c;
        super.installUI(c);
    }

    @Override
    protected void installDefaults(JComponent c) {
        super.installDefaults(c);
        this.toolTip.putClientProperty("JPopupFactory.noDecorations", !this.useDecoratedPopup());
        this.toolTip.putClientProperty("JPopupFactory.startHidden", true);
        this.toolTip.putClientProperty("JPopupFactory.forceHeavyweight", true);
        this.toolTip.setOpaque(false);
        this.fadeAnimator = new FadeInAnimator();
        this.updateTipText(this.toolTip);
        this.updateStyle();
    }

    protected boolean useDecoratedPopup() {
        return false;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.style.isOpaque()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(PaintUtil.TRANSPARENT_COLOR);
        }
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        this.paint(g, c);
    }

    @Override
    protected void installListeners(JComponent c) {
        super.installListeners(c);
        c.addHierarchyListener(this);
        c.addPropertyChangeListener(this);
        c.addMouseListener(this.exitListener);
        JComponent comp = this.toolTip.getComponent();
        if (comp != null) {
            comp.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.fadeAnimator.dispose();
        this.toolTip = null;
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        c.removePropertyChangeListener(this);
        c.removeMouseListener(this.exitListener);
        c.removeHierarchyListener(this);
        JComponent comp = this.toolTip.getComponent();
        if (comp != null) {
            comp.removeMouseListener(this.mouseListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isPlain;
        if (this.getTipText().isEmpty()) {
            return;
        }
        boolean bl = isPlain = this.style == ToolTipStyle.PLAIN;
        if (this.animationScheduled) {
            this.startAnimation();
        } else {
            Window window = DarkUIUtil.getWindow(c);
            if (window != null && window.getOpacity() != 1.0f && !this.transparencySupported(window)) {
                window.setOpacity(1.0f);
            }
        }
        GraphicsContext context = GraphicsUtil.setupAntialiasing(g);
        g.setColor(c.getBackground());
        if (!isPlain && c.getBorder() instanceof DarkTooltipBorder) {
            Area area = ((DarkTooltipBorder)c.getBorder()).getBackgroundArea(c, c.getWidth(), c.getHeight());
            ((Graphics2D)g).fill(area);
        } else {
            PaintUtil.fillRect(g, 0, 0, c.getWidth(), c.getHeight());
        }
        this.paintText(g, c);
        context.restore();
    }

    protected void startAnimation() {
        this.animationScheduled = false;
        this.fadeAnimator.reset();
        this.alpha = 0.0f;
        this.fadeAnimator.resume();
    }

    protected void paintText(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = this.getTipText();
        if (tipText != "NO_TEXT") {
            Insets insets = c.getInsets();
            Rectangle paintTextR = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
            StringPainter.drawString(g, c, tipText, paintTextR);
        }
    }

    protected String getTipText() {
        if (this.effectiveTipText == null) {
            this.updateTipText(this.toolTip);
        }
        if (this.effectiveTipText == null) {
            this.effectiveTipText = "";
        }
        return this.effectiveTipText;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = this.getTipText();
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0);
                prefSize.height += (int)v.getPreferredSpan(1);
            } else {
                prefSize.width += fm.stringWidth(text);
                prefSize.height += fm.getHeight();
            }
        }
        return prefSize;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        Container component = this.toolTip.getParent();
        if (component instanceof JComponent && this.style != ToolTipStyle.PLAIN) {
            ((JComponent)component).setOpaque(false);
            component.setBackground(new DarkColorUIResource(ColorUtil.toAlpha(component.getBackground(), 0)));
        }
    }

    protected boolean isInside(MouseEvent e) {
        if (this.toolTip.getComponent() == null) {
            return true;
        }
        Point screenPos = e.getPoint();
        SwingUtilities.convertPointToScreen(screenPos, e.getComponent());
        Point toolTipPoint = new Point(screenPos.x, screenPos.y);
        Point compPoint = new Point(screenPos.x, screenPos.y);
        SwingUtilities.convertPointFromScreen(toolTipPoint, this.toolTip);
        SwingUtilities.convertPointFromScreen(compPoint, this.toolTip.getComponent());
        return this.toolTip.getComponent().contains(compPoint) || this.contains(this.toolTip, toolTipPoint.x, toolTipPoint.y);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        Border b = c.getBorder();
        if (b instanceof DarkTooltipBorder) {
            Area insideArea = ((DarkTooltipBorder)b).getBackgroundArea(this.toolTip, this.toolTip.getWidth(), this.toolTip.getHeight());
            return insideArea.contains(x, y);
        }
        return super.contains(c, x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (evt.getSource() instanceof JToolTip) {
            JToolTip tooltip = (JToolTip)evt.getSource();
            if (tooltip.getBorder() instanceof AlignableTooltipBorder) {
                AlignableTooltipBorder b = (AlignableTooltipBorder)((Object)tooltip.getBorder());
                Object newVal = evt.getNewValue();
                if ("JToolTip.pointerLocation".equals(key)) {
                    if (newVal instanceof Alignment) {
                        b.setPointerLocation((Alignment)((Object)newVal), this.pointerEnabled());
                    } else {
                        b.setPointerLocation(Alignment.CENTER, this.pointerEnabled());
                    }
                    this.updateSize();
                }
                if (b instanceof DarkTooltipBorder) {
                    DarkTooltipBorder border = (DarkTooltipBorder)tooltip.getBorder();
                    if (this.pointerEnabled() && "JToolTip.pointerHeight".equals(key)) {
                        if (newVal instanceof Integer) {
                            border.setPointerHeight((Integer)newVal);
                        }
                        this.updateSize();
                    } else if (this.pointerEnabled() && "JToolTip.pointerWidth".equals(key)) {
                        if (newVal instanceof Integer) {
                            border.setPointerWidth((Integer)newVal);
                        }
                        this.updateSize();
                    } else if ("JToolTip.insets".equals(key)) {
                        this.updateSize();
                    }
                }
            }
            if ("component".equals(key)) {
                Object newComp;
                Object oldComp = evt.getOldValue();
                if (oldComp instanceof Component) {
                    ((Component)oldComp).removeMouseListener(this.mouseListener);
                    ((Component)oldComp).removePropertyChangeListener(this.componentPropertyChaneListener);
                }
                if ((newComp = evt.getNewValue()) instanceof Component) {
                    ((Component)newComp).addMouseListener(this.mouseListener);
                    ((Component)newComp).addPropertyChangeListener(this.componentPropertyChaneListener);
                }
                this.updateStyle();
            } else if ("tiptext".equals(key)) {
                this.updateTipText(tooltip);
                this.updateSize();
            } else if ("ancestor".equals(key)) {
                if (evt.getOldValue() == null) {
                    this.scheduleAnimation();
                    ToolTipUtil.applyContext(this.toolTip);
                }
                if (evt.getNewValue() == null) {
                    this.alpha = 0.0f;
                }
            } else if ("JToolTip.style".equals(key)) {
                this.updateStyle();
            }
        }
    }

    protected boolean pointerEnabled() {
        return this.style.supportsPointer();
    }

    protected void updateTipText(JToolTip tooltip) {
        this.effectiveTipText = tooltip.getTipText();
        if (this.effectiveTipText == null) {
            this.effectiveTipText = "";
        }
    }

    protected void scheduleAnimation() {
        Window window = DarkUIUtil.getWindow(this.toolTip);
        this.animationScheduled = this.transparencySupported(DarkUIUtil.getWindow(this.toolTip));
        if (window != null && this.animationScheduled) {
            window.setOpacity(0.1f);
        }
    }

    protected boolean transparencySupported(Window window) {
        return this.style != ToolTipStyle.PLAIN && GraphicsUtil.supportsTransparency(window);
    }

    protected void updateStyle() {
        JComponent comp = this.toolTip.getComponent();
        ToolTipStyle style = comp != null ? ToolTipStyle.parse(comp.getClientProperty("JToolTip.style")) : null;
        ToolTipStyle tooltipStyle = ToolTipStyle.parse(this.toolTip.getClientProperty("JToolTip.style"));
        if (style == null) {
            style = tooltipStyle;
        }
        if (style == null) {
            style = ToolTipStyle.parse(UIManager.get("ToolTip.defaultStyle"));
        }
        if (style.isOpaque() && !GraphicsUtil.supportsTransparency()) {
            style = ToolTipStyle.PLAIN;
        }
        if (style != tooltipStyle) {
            this.toolTip.putClientProperty("JToolTip.style", style);
        }
        if (style != this.style) {
            this.style = style;
            this.updateBorder(style);
            this.toolTip.putClientProperty("JPopupFactory.opaque", style.isOpaque());
        }
    }

    protected void updateBorder(ToolTipStyle style) {
        if (style == ToolTipStyle.PLAIN) {
            this.toolTip.setBorder(new DarkDefaultToolTipBorder());
        } else {
            DarkTooltipBorder border = new DarkTooltipBorder();
            border.setPointerLocation(Alignment.CENTER, this.pointerEnabled());
            this.toolTip.setBorder(border);
        }
    }

    protected void updateSize() {
        this.toolTip.doLayout();
    }

    protected class FadeInAnimator
    extends Animator {
        private static final int FADEIN_FRAMES_COUNT = 15;

        public FadeInAnimator() {
            super(15, 225, false);
        }

        @Override
        public boolean isEnabled() {
            return DarkToolTipUI.this.toolTip.getComponent() != null && super.isEnabled();
        }

        @Override
        public void paintNow(float fraction) {
            DarkToolTipUI.this.alpha = 0.1f + fraction * 0.9f;
            Window window = SwingUtilities.getWindowAncestor(DarkToolTipUI.this.toolTip);
            if (DarkUIUtil.isDecorated(window)) {
                return;
            }
            if (window != null) {
                window.setOpacity(DarkToolTipUI.this.alpha);
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkToolTipUI.this.alpha = 1.0f;
            Window window = SwingUtilities.getWindowAncestor(DarkToolTipUI.this.toolTip);
            if (window != null && !DarkUIUtil.isDecorated(window)) {
                window.setOpacity(DarkToolTipUI.this.alpha);
            }
        }
    }
}

