/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.Outline;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarkTextBorder
implements Border,
UIResource,
VisualPaddingProvider {
    protected final Color errorBorderColor;
    protected final Color focusErrorBorderColor = UIManager.getColor("TextField.border.focusError");
    protected final Color warningBorderColor;
    protected final Color focusWarningBorderColor = UIManager.getColor("TextField.border.focusWarning");
    protected final Color focusBorderColor = UIManager.getColor("TextField.border.focus");
    protected final Color borderColor;
    protected final Color inactiveBorderColor;
    protected final Color inactiveFocusBorderColor;
    protected final int borderSize;
    protected final int arc;
    protected final int searchArc;
    protected final int focusArc;
    protected final int searchFocusArc;

    public DarkTextBorder() {
        this.errorBorderColor = UIManager.getColor("TextField.border.error");
        this.warningBorderColor = UIManager.getColor("TextField.border.warning");
        this.borderColor = UIManager.getColor("TextField.border.enabled");
        this.inactiveBorderColor = UIManager.getColor("TextField.border.disabled");
        this.inactiveFocusBorderColor = UIManager.getColor("TextField.border.disabled.focus");
        this.borderSize = UIManager.getInt("TextField.borderThickness");
        this.arc = UIManager.getInt("TextField.arc");
        this.focusArc = UIManager.getInt("TextField.focusArc");
        this.searchArc = UIManager.getInt("TextField.searchArc");
        this.searchFocusArc = UIManager.getInt("TextField.searchFocusArc");
    }

    protected static boolean hasError(Component c) {
        return PropertyUtil.getBooleanProperty(c, "JTextComponent.hasError");
    }

    protected static boolean hasWarning(Component c) {
        return PropertyUtil.getBooleanProperty(c, "JTextComponent.hasWarning");
    }

    protected int getArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchArc : this.arc;
    }

    protected int getFocusArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchFocusArc : this.focusArc;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
        boolean focus = DarkUIUtil.hasFocus(c);
        boolean error = DarkTextBorder.hasError(c);
        boolean warning = !error && DarkTextBorder.hasWarning(c);
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        int arcSize = this.getArcSize(c);
        int focusArcSize = this.getFocusArcSize(c);
        this.paintFocus(g, c, width, height, editable, error, warning, focusArcSize);
        g.setColor(this.getBorderColor(focus, error, warning, editable, c.isEnabled()));
        PaintUtil.paintLineBorder(g, this.borderSize, this.borderSize, width - 2 * this.borderSize, height - 2 * this.borderSize, arcSize);
        g.translate(-x, -y);
        config.restore();
    }

    public void paintFocus(Graphics2D g, Component c, int width, int height, boolean editable, boolean error, boolean warning, int focusArcSize) {
        if (error) {
            PaintUtil.paintOutlineBorder(g, width, height, focusArcSize, this.borderSize, c.hasFocus(), Outline.error);
        } else if (warning) {
            PaintUtil.paintOutlineBorder(g, width, height, focusArcSize, this.borderSize, c.hasFocus(), Outline.warning);
        } else if (c.hasFocus()) {
            PaintUtil.paintFocusBorder(g, width, height, focusArcSize, this.borderSize, editable);
        }
    }

    protected Color getBorderColor(boolean focus, boolean error, boolean warning, boolean editable, boolean enabled) {
        if (focus) {
            if (error) {
                return this.focusErrorBorderColor;
            }
            if (warning) {
                return this.focusWarningBorderColor;
            }
            return enabled && editable ? this.focusBorderColor : this.inactiveFocusBorderColor;
        }
        if (error) {
            return this.errorBorderColor;
        }
        if (warning) {
            return this.warningBorderColor;
        }
        return enabled && editable ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getVisualPaddings(Component component) {
        return this.getBorderInsets(component);
    }
}

