/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.header;

import com.github.weisj.darklaf.ui.table.DarkTableScrollPaneBorder;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.header.DarkTableHeaderRendererDelegate;
import com.github.weisj.darklaf.ui.table.header.DarkTableHeaderRendererPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarkTableHeaderUI
extends BasicTableHeaderUI {
    private static final int HEADER_HEIGHT = 26;
    protected Color borderColor;
    protected Color background;
    protected int defaultHeight;
    protected DarkTableHeaderRendererDelegate rendererDelegate;
    private int lastMaxVisible = -1;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.header.remove(this.rendererPane);
        this.rendererPane = this.createCellRendererPane();
        this.header.add(this.rendererPane);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.background = UIManager.getColor("TableHeader.background");
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        LookAndFeel.installBorder(this.header, "TableHeader.border");
        this.defaultHeight = UIManager.getInt("TableHeader.height");
        if (this.defaultHeight <= 0) {
            this.defaultHeight = 26;
        }
        this.rendererDelegate = new DarkTableHeaderRendererDelegate(this.header.getDefaultRenderer());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        dim.height = Math.max(this.defaultHeight, dim.height);
        return dim;
    }

    protected CellRendererPane createCellRendererPane() {
        return new DarkTableHeaderRendererPane();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.header);
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = new GraphicsContext(g);
        int x = 0;
        int y = 0;
        int h = c.getHeight();
        int w = c.getWidth();
        g.setColor(this.getHeaderBackground());
        g.fillRect(x, y, w, h);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point leftClip = clip.getLocation();
        Point rightCip = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = Math.max(this.header.columnAtPoint(ltr ? leftClip : rightCip), 0);
        int cMax = this.header.columnAtPoint(ltr ? rightCip : leftClip);
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        Rectangle bounds = c.getVisibleRect();
        Point left = bounds.getLocation();
        Point right = new Point(bounds.x + bounds.width - 1, bounds.y);
        int cMinVisible = Math.max(this.header.columnAtPoint(ltr ? left : right), 0);
        int cMaxVisible = this.header.columnAtPoint(ltr ? right : left);
        if (cMaxVisible == -1) {
            cMaxVisible = cm.getColumnCount() - 1;
        }
        Color borderColor = c.getBorder() instanceof DarkTableScrollPaneBorder ? ((DarkTableScrollPaneBorder)c.getBorder()).getBorderColor() : this.getBorderColor();
        g.setColor(borderColor);
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        this.paintCells(g, h, ltr, cm, cMin, cMax, cMinVisible, cMaxVisible, borderColor, draggedColumn, cellRect);
        if (draggedColumn != null) {
            this.paintDraggedArea(g, ltr, cMin, cMax, borderColor, draggedColumn);
        }
        this.rendererPane.removeAll();
        config.restore();
        if (this.lastMaxVisible != cMaxVisible) {
            if (this.lastMaxVisible >= 0) {
                Rectangle r = this.header.getHeaderRect(this.lastMaxVisible);
                SwingUtilities.invokeLater(() -> this.header.repaint(r));
            }
            this.lastMaxVisible = cMaxVisible;
        }
    }

    public void paintCells(Graphics2D g, int h, boolean ltr, TableColumnModel cm, int cMin, int cMax, int cMinVisible, int cMaxVisible, Color borderColor, TableColumn draggedColumn, Rectangle cellRect) {
        if (ltr) {
            for (int column = cMin; column <= cMax; ++column) {
                this.paintSingleCell(g, h, cm, cMinVisible, cMaxVisible, borderColor, draggedColumn, cellRect, column);
            }
        } else {
            for (int column = cMax; column >= cMin; --column) {
                this.paintSingleCell(g, h, cm, cMinVisible, cMaxVisible, borderColor, draggedColumn, cellRect, column);
            }
        }
    }

    public void paintSingleCell(Graphics2D g, int h, TableColumnModel cm, int cMinVisible, int cMaxVisible, Color borderColor, TableColumn draggedColumn, Rectangle cellRect, int column) {
        int columnWidth;
        TableColumn aColumn = cm.getColumn(column);
        cellRect.width = columnWidth = aColumn.getWidth();
        if (aColumn != draggedColumn) {
            this.paintCell(g, cellRect, column);
        }
        g.setColor(borderColor);
        if (column < cMaxVisible) {
            g.fillRect(cellRect.x + cellRect.width - 1, 0, 1, h);
        }
        cellRect.x += cellRect.width;
    }

    public void paintDraggedArea(Graphics2D g, boolean ltr, int cMin, int cMax, Color borderColor, TableColumn draggedColumn) {
        boolean onRightEdge;
        boolean onLeftEdge;
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        boolean scrollPaneRtl = this.isScrollPaneRtl();
        Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
        int dist = DarkTableUI.adjustDistance(this.header.getDraggedDistance(), draggedCellRect, this.header.getTable());
        g.setColor(this.header.getParent().getBackground());
        g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
        g.setColor(borderColor);
        if (this.scrollBarVisible()) {
            if (ltr) {
                if (!scrollPaneRtl) {
                    g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                } else {
                    if (draggedColumnIndex != cMax) {
                        g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                    } else {
                        g.fillRect(draggedCellRect.x + draggedCellRect.width, draggedCellRect.y, 1, draggedCellRect.height);
                    }
                    if (draggedColumnIndex == cMin) {
                        g.fillRect(draggedCellRect.x, draggedCellRect.y, 1, draggedCellRect.height);
                    }
                }
            } else if (!scrollPaneRtl) {
                g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
            } else {
                if (draggedColumnIndex != cMin) {
                    g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                }
                if (draggedColumnIndex == cMax) {
                    g.fillRect(draggedCellRect.x, draggedCellRect.y, 1, draggedCellRect.height);
                }
            }
        } else if (ltr) {
            if (draggedColumnIndex != cMax) {
                g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
            } else {
                g.fillRect(draggedCellRect.x + draggedCellRect.width, draggedCellRect.y, 1, draggedCellRect.height);
            }
        } else if (draggedColumnIndex != cMin) {
            g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
        }
        draggedCellRect.x += dist;
        g.setColor(this.header.getBackground());
        g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
        this.paintCell(g, draggedCellRect, draggedColumnIndex);
        g.setColor(borderColor);
        boolean bl = ltr ? draggedColumnIndex == cMin : (onLeftEdge = draggedColumnIndex == cMax);
        boolean bl2 = ltr ? draggedColumnIndex == cMax : (onRightEdge = draggedColumnIndex == cMin);
        if (dist != 0 || !onLeftEdge) {
            g.fillRect(draggedCellRect.x - 1, draggedCellRect.y, 1, draggedCellRect.height);
        }
        if (dist != 0 || !onRightEdge) {
            g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
        }
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderCellRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected Color getHeaderBackground() {
        return this.background;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected boolean isScrollPaneRtl() {
        if (!this.isInScrollPane()) {
            return false;
        }
        Container comp = DarkUIUtil.getUnwrappedParent(this.header).getParent();
        return !comp.getComponentOrientation().isLeftToRight();
    }

    protected boolean scrollBarVisible() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.header);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane && ((JScrollPane)comp).getVerticalScrollBar().isVisible();
    }

    protected boolean isInScrollPane() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.header);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane;
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected Component getHeaderCellRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean hasFocus = !this.header.isPaintingForPrint() && this.header.hasFocus();
        this.rendererDelegate.setDelegate(renderer);
        return this.rendererDelegate.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
    }
}

