/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitbutton;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.components.button.JSplitButton;
import com.github.weisj.darklaf.icons.ToggleIcon;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import com.github.weisj.darklaf.ui.splitbutton.DarkSplitButtonBorder;
import com.github.weisj.darklaf.ui.splitbutton.DarkSplitButtonListener;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkSplitButtonUI
extends DarkButtonUI {
    protected JSplitButton splitButton;
    protected AbstractButton arrowButton;
    private DarkSplitButtonListener arrowButtonListener;
    private Icon overlayIcon;
    private Icon overlayDisabledIcon;
    private ToggleIcon arrowToggleIcon;
    private ToggleIcon arrowDisabledToggleIcon;
    private Insets arrowInsets;
    private Insets arrowInsetsThin;
    private final Insets arrowButtonMargin = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new DarkSplitButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.splitButton = (JSplitButton)c;
        super.installUI(c);
        this.updateDefaultAction();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.splitButton = null;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.overlayIcon = UIManager.getIcon("SplitButton.overlayIcon");
        this.overlayDisabledIcon = UIManager.getIcon("SplitButton.overlayDisabledIcon");
        this.arrowInsets = UIManager.getInsets("SplitButton.arrowInsets");
        this.arrowInsetsThin = UIManager.getInsets("SplitButton.arrowThinInsets");
        Icon arrowIcon = UIManager.getIcon("SplitButton.arrowIcon");
        Icon arrowIconDisabled = UIManager.getIcon("SplitButton.arrowIconDisabled");
        Icon arrowIconThin = UIManager.getIcon("SplitButton.arrowThinIcon");
        Icon arrowIconThinDisabled = UIManager.getIcon("SplitButton.arrowThinIconDisabled");
        this.arrowToggleIcon = new ToggleIcon(arrowIcon, arrowIconThin);
        this.arrowDisabledToggleIcon = new ToggleIcon(arrowIconDisabled, arrowIconThinDisabled);
        PropertyUtil.installBorder(this.splitButton, new DarkSplitButtonBorder());
        this.arrowButton = this.createArrowButton();
        this.configureArrowButton(this.arrowButton);
        this.splitButton.add(this.arrowButton);
        this.updateArrowMargin();
    }

    protected void configureArrowButton(AbstractButton button) {
        button.setRequestFocusEnabled(false);
        button.setInheritsPopupMenu(true);
        button.resetKeyboardActions();
        button.setEnabled(this.splitButton.isEnabled());
        button.putClientProperty("consumeEventOnClose", true);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.arrowButtonListener = this.createArrowButtonListener();
        this.arrowButton.addActionListener(this.arrowButtonListener);
        this.splitButton.addActionListener(this.arrowButtonListener);
        this.arrowButton.getModel().addChangeListener(this.arrowButtonListener);
        this.splitButton.addPropertyChangeListener(this.arrowButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        this.arrowButton.removeActionListener(this.arrowButtonListener);
        this.splitButton.removeActionListener(this.arrowButtonListener);
        this.arrowButton.getModel().removeActionListener(this.arrowButtonListener);
        this.splitButton.removePropertyChangeListener(this.arrowButtonListener);
        this.arrowButtonListener = null;
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.splitButton.remove(this.arrowButton);
        this.arrowButton = null;
    }

    protected void updateArrowMargin() {
        if (ButtonConstants.isThin(this.splitButton)) {
            this.arrowButtonMargin.set(this.arrowInsetsThin.top, this.arrowInsetsThin.left, this.arrowInsetsThin.bottom, this.arrowInsetsThin.right);
            this.arrowToggleIcon.setChooseAlternativeIcon(true);
        } else {
            this.arrowButtonMargin.set(this.arrowInsets.top, this.arrowInsets.left, this.arrowInsets.bottom, this.arrowInsets.right);
            this.arrowToggleIcon.setChooseAlternativeIcon(false);
        }
        this.splitButton.doLayout();
    }

    protected DarkSplitButtonListener createArrowButtonListener() {
        return new DarkSplitButtonListener(this);
    }

    protected AbstractButton createArrowButton() {
        JButton b = ArrowButton.createUpDownArrow(this.splitButton, this.arrowToggleIcon, this.arrowDisabledToggleIcon, 5, true, true, this.arrowButtonMargin);
        b.setRolloverEnabled(true);
        return b;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        if (this.useArrowButton()) {
            Dimension arrowSize = this.arrowButton.getPreferredSize();
            dim.width += arrowSize.width;
            dim.height = Math.max(dim.height, arrowSize.height);
        }
        return dim;
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarkSplitButtonLayout();
    }

    protected boolean useArrowButton() {
        return this.arrowButton != null && this.splitButton.getActionCount() > 1;
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton b, JComponent c) {
        super.paintIcon(g, b, c);
        if (b.getIcon() != null && !this.useArrowButton()) {
            Icon overlay;
            if (b.isEnabled()) {
                overlay = this.splitButton.getOverlayDropDownIcon();
                if (overlay == null) {
                    overlay = this.overlayIcon;
                }
            } else {
                overlay = this.splitButton.getOverlayDropDownDisabledIcon();
                if (overlay == null) {
                    overlay = this.overlayDisabledIcon;
                }
            }
            overlay.paintIcon(c, g, this.iconRect.x + this.iconRect.width - overlay.getIconWidth(), this.iconRect.y + this.iconRect.height - overlay.getIconHeight());
        }
    }

    @Override
    public boolean isRolloverBorderless(AbstractButton b) {
        return super.isRolloverBorderless(b) || this.useArrowButton() && this.arrowButton.getModel().isRollover();
    }

    @Override
    protected void paintDarklafBorderBgImpl(AbstractButton c, Graphics2D g, boolean showShadow, int shadow, int effectiveArc, Rectangle bgRect) {
        super.paintDarklafBorderBgImpl(c, g, showShadow, shadow, effectiveArc, bgRect);
        if (this.useArrowButton()) {
            boolean isDefault = this.splitButton.isDefaultButton();
            boolean enabled = this.splitButton.isEnabled();
            boolean rollover = c.isRolloverEnabled() && this.arrowButton.getModel().isRollover();
            boolean clicked = this.arrowButton.getModel().isArmed();
            g.setColor(this.getBackgroundColor(this.splitButton, isDefault, rollover, clicked, enabled));
            Shape clip = g.getClip();
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            if (ltr) {
                g.clipRect(this.arrowButton.getX(), 0, this.button.getWidth(), this.button.getHeight());
            } else {
                g.clipRect(0, 0, this.arrowButton.getX() + this.arrowButton.getWidth(), this.button.getHeight());
            }
            this.paintBackgroundRect(g, effectiveArc, bgRect);
            g.setClip(clip);
        }
    }

    protected void setArmedClip(AbstractButton c, Graphics g) {
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        boolean arrowArmed = this.arrowButton.getModel().isRollover();
        if (ltr) {
            if (arrowArmed) {
                g.clipRect(this.arrowButton.getX(), 0, this.splitButton.getWidth(), this.splitButton.getHeight());
            } else {
                g.clipRect(0, 0, this.arrowButton.getX(), this.splitButton.getHeight());
            }
        } else if (arrowArmed) {
            g.clipRect(0, 0, this.arrowButton.getX() + this.arrowButton.getWidth(), this.splitButton.getHeight());
        } else {
            g.clipRect(this.arrowButton.getX() + this.arrowButton.getWidth(), 0, this.splitButton.getWidth(), this.splitButton.getHeight());
        }
    }

    @Override
    protected void paintBorderlessBackgroundImpl(AbstractButton b, Graphics2D g, int arc, int x, int y, int w, int h) {
        boolean splitArmed = this.splitButton.getModel().isArmed();
        boolean arrowArmed = this.arrowButton.getModel().isArmed();
        Shape clip = g.getClip();
        if (splitArmed) {
            super.paintBorderlessBackgroundImpl(this.arrowButton, g, arc, x, y, w, h);
            this.setArmedClip(this.splitButton, g);
            super.paintBorderlessBackgroundImpl(this.splitButton, g, arc, x, y, w, h);
        } else if (arrowArmed) {
            super.paintBorderlessBackgroundImpl(this.splitButton, g, arc, x, y, w, h);
            this.setArmedClip(this.splitButton, g);
            super.paintBorderlessBackgroundImpl(this.arrowButton, g, arc, x, y, w, h);
        } else {
            super.paintBorderlessBackgroundImpl(b, g, arc, x, y, w, h);
        }
        g.setClip(clip);
    }

    @Override
    protected void paintBorderlessRectangularBackgroundIml(AbstractButton b, Graphics2D g, int x, int y, int w, int h) {
        boolean splitArmed = this.splitButton.getModel().isArmed();
        boolean arrowArmed = this.splitButton.getModel().isArmed();
        Shape clip = g.getClip();
        if (splitArmed) {
            super.paintBorderlessRectangularBackgroundIml(this.arrowButton, g, x, y, w, h);
            this.setArmedClip(this.splitButton, g);
            super.paintBorderlessRectangularBackgroundIml(this.splitButton, g, x, y, w, h);
        } else if (arrowArmed) {
            super.paintBorderlessRectangularBackgroundIml(this.splitButton, g, x, y, w, h);
            this.setArmedClip(this.splitButton, g);
            super.paintBorderlessRectangularBackgroundIml(this.arrowButton, g, x, y, w, h);
        } else {
            super.paintBorderlessRectangularBackgroundIml(b, g, x, y, w, h);
        }
        g.setClip(clip);
    }

    public void updateDefaultAction() {
        this.arrowButton.setVisible(this.useArrowButton());
        this.splitButton.putClientProperty("consumeEventOnClose", !this.useArrowButton());
    }

    protected class DarkSplitButtonLayout
    extends DarkButtonUI.DarkButtonLayout {
        protected DarkSplitButtonLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            if (DarkSplitButtonUI.this.useArrowButton()) {
                Insets ins = parent.getInsets();
                Dimension arrowSize = DarkSplitButtonUI.this.arrowButton.getPreferredSize();
                boolean ltr = DarkSplitButtonUI.this.splitButton.getComponentOrientation().isLeftToRight();
                if (ltr) {
                    DarkSplitButtonUI.this.arrowButton.setBounds(parent.getWidth() - ins.right - arrowSize.width, 0, arrowSize.width + ins.right, parent.getHeight());
                    DarkSplitButtonUI.this.arrowButton.setMargin(new Insets(ins.top, 0, ins.bottom, ins.right));
                } else {
                    DarkSplitButtonUI.this.arrowButton.setBounds(ins.left, ins.top, arrowSize.width, parent.getHeight() - ins.top - ins.bottom);
                    DarkSplitButtonUI.this.arrowButton.setMargin(new Insets(ins.top, ins.left, ins.bottom, 0));
                }
            }
        }

        @Override
        protected void prepareContentRects(AbstractButton b, int width, int height) {
            super.prepareContentRects(b, width, height);
            if (DarkSplitButtonUI.this.useArrowButton()) {
                Dimension arrowSize = DarkSplitButtonUI.this.arrowButton.getPreferredSize();
                boolean ltr = DarkSplitButtonUI.this.splitButton.getComponentOrientation().isLeftToRight();
                ((DarkSplitButtonUI)DarkSplitButtonUI.this).viewRect.width -= arrowSize.width;
                if (!ltr) {
                    ((DarkSplitButtonUI)DarkSplitButtonUI.this).viewRect.x += arrowSize.width;
                }
            }
        }
    }
}

