/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.swingdsl.VisualPaddingListener;
import com.github.weisj.darklaf.ui.DividedWidgetPainter;
import com.github.weisj.darklaf.ui.spinner.DarkSpinnerLayout;
import com.github.weisj.darklaf.ui.spinner.DarkSpinnerListener;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import com.github.weisj.darklaf.ui.spinner.SpinnerIcon;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;

public class DarkSpinnerUI
extends BasicSpinnerUI
implements SpinnerConstants {
    protected DarkSpinnerListener spinnerListener;
    protected Color arrowBackground;
    protected Color background;
    protected Icon arrowDownIcon;
    protected Color inactiveBackground;
    protected int arc;
    protected Icon arrowUpIcon;
    protected Icon plusIcon;
    protected Icon minusIcon;
    protected Icon arrowDownInactiveIcon;
    protected Icon arrowUpInactiveIcon;
    protected Icon plusInactiveIcon;
    protected Icon minusInactiveIcon;
    private JComponent editor;
    private JButton prevButton;
    private JComponent editorComponent;
    private VisualPaddingListener visualPaddingListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arc = UIManager.getInt("Spinner.arc");
        this.background = UIManager.getColor("Spinner.activeBackground");
        this.inactiveBackground = UIManager.getColor("Spinner.inactiveBackground");
        this.arrowBackground = UIManager.getColor("Spinner.arrowBackground");
        this.arrowDownIcon = UIManager.getIcon("Spinner.arrowDown.icon");
        this.arrowUpIcon = UIManager.getIcon("Spinner.arrowUp.icon");
        this.minusIcon = UIManager.getIcon("Spinner.minus.icon");
        this.plusIcon = UIManager.getIcon("Spinner.plus.icon");
        this.arrowDownInactiveIcon = UIManager.getIcon("Spinner.arrowDownInactive.icon");
        this.arrowUpInactiveIcon = UIManager.getIcon("Spinner.arrowUpInactive.icon");
        this.minusInactiveIcon = UIManager.getIcon("Spinner.minusInactive.icon");
        this.plusInactiveIcon = UIManager.getIcon("Spinner.plusInactive.icon");
        this.updateBackground();
        LookAndFeel.installProperty(this.spinner, "opaque", false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.spinnerListener = this.createSpinnerListener();
        this.spinner.addMouseListener(this.spinnerListener);
        this.spinner.addMouseWheelListener(this.spinnerListener);
        this.spinner.addPropertyChangeListener(this.spinnerListener);
        this.visualPaddingListener = new VisualPaddingListener();
        this.spinner.addPropertyChangeListener(this.visualPaddingListener);
    }

    protected DarkSpinnerListener createSpinnerListener() {
        return new DarkSpinnerListener(this.spinner, this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.editor != null && this.editor.getComponents().length > 0) {
            this.editor.getComponents()[0].removeFocusListener(this.spinnerListener);
        }
        this.spinner.removeMouseListener(this.spinnerListener);
        this.spinner.removeMouseWheelListener(this.spinnerListener);
        this.spinner.removePropertyChangeListener(this.spinnerListener);
        this.spinnerListener = null;
        this.spinner.removePropertyChangeListener(this.visualPaddingListener);
        this.visualPaddingListener = null;
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarkSpinnerLayout();
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createArrow(5);
        this.prevButton.setName("Spinner.previousButton");
        this.prevButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.prevButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        JButton nextButton = this.createArrow(1);
        nextButton.setName("Spinner.nextButton");
        nextButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        nextButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installNextButtonListeners(nextButton);
        return nextButton;
    }

    @Override
    protected JComponent createEditor() {
        this.editor = super.createEditor();
        this.updateEditorComponent();
        return this.editor;
    }

    private void updateEditorComponent() {
        this.editorComponent = this.editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)this.editor).getTextField() : this.editor;
        if (this.editorComponent instanceof JTextComponent) {
            ((JTextComponent)this.editorComponent).setMargin(new Insets(0, 0, 0, 0));
        }
        this.editorComponent.addFocusListener(this.spinnerListener);
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.editor = newEditor;
        if (oldEditor != null && oldEditor.getComponents().length > 0) {
            oldEditor.getComponents()[0].removeFocusListener(this.spinnerListener);
        }
        this.updateEditorComponent();
    }

    private JButton createArrow(int direction) {
        Insets insets = UIManager.getInsets("Spinner.arrowButtonInsets");
        JButton button = ArrowButton.createUpDownArrow(this.spinner, this.getArrowIcon(direction), this.getArrowInactiveIcon(direction), direction, false, true, insets);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            button.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            button.setBorder(buttonBorder);
        }
        button.setInheritsPopupMenu(true);
        return button;
    }

    protected SpinnerIcon getArrowIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownIcon, this.minusIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpIcon, this.plusIcon);
    }

    protected SpinnerIcon getArrowInactiveIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownInactiveIcon, this.minusInactiveIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpInactiveIcon, this.plusInactiveIcon);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null && parent.isOpaque() && !c.isEnabled()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            return;
        }
        Rectangle arrowBounds = this.prevButton.getBounds();
        Color bg = this.getBackground(c);
        Color spinBg = this.getArrowBackground(c);
        boolean isCellEditor = SpinnerConstants.isTreeOrTableCellEditor(c);
        if (this.editorComponent != null) {
            PropertyUtil.installBackground(this.editorComponent, bg);
            bg = this.editorComponent.getBackground();
        }
        DividedWidgetPainter.paintBackground((Graphics2D)g, c, this.arc, arrowBounds, bg, spinBg, isCellEditor);
    }

    protected Color getBackground(JComponent c) {
        return c == null ? this.inactiveBackground : c.getBackground();
    }

    protected void updateBackground() {
        PropertyUtil.installBackground(this.spinner, this.spinner.isEnabled() ? this.background : this.inactiveBackground);
    }

    protected Color getArrowBackground(JComponent c) {
        return c == null || !c.isEnabled() ? this.inactiveBackground : this.arrowBackground;
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }

    public JComponent getEditor() {
        return this.editor;
    }
}

