/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.progressbar;

import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class DarkProgressBarUI
extends BasicProgressBarUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JProgressBar.";
    public static final String KEY_FAILED = "JProgressBar.failed";
    public static final String KEY_PASSED = "JProgressBar.passed";
    private static final int CYCLE_TIME_DEFAULT = 800;
    private static final int REPAINT_INTERVAL_DEFAULT = 50;
    private static final int CYCLE_TIME_SIMPLIFIED = 1000;
    private static final int REPAINT_INTERVAL_SIMPLIFIED = 500;
    private Color trackColor;
    private Color progressColor;
    private Color indeterminateStartColor;
    private Color indeterminateEndColor;
    private Color failedColor;
    private Color failedEndColor;
    private Color passedColor;
    private Color passedEndColor;
    private int stripeWidth;

    public static ComponentUI createUI(JComponent c) {
        return new DarkProgressBarUI();
    }

    protected static boolean hasFailed(JComponent c) {
        return PropertyUtil.getBooleanProperty(c, KEY_FAILED);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Color endColor;
            Color startColor;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque()) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i = this.progressBar.getInsets();
            DarkUIUtil.applyInsets(r, i);
            int orientation = this.progressBar.getOrientation();
            if (DarkProgressBarUI.hasFailed(this.progressBar)) {
                startColor = this.failedColor;
                endColor = this.failedEndColor;
            } else if (DarkProgressBarUI.hasPassed(this.progressBar)) {
                startColor = this.passedColor;
                endColor = this.passedEndColor;
            } else {
                startColor = this.getStartColor();
                endColor = this.getEndColor();
            }
            int pHeight = this.progressBar.getPreferredSize().height;
            int pWidth = this.progressBar.getPreferredSize().width;
            int yOffset = r.y + (r.height - pHeight) / 2;
            int xOffset = r.x + (r.width - pWidth) / 2;
            if (DarkProgressBarUI.isSimplified()) {
                Color[] ca = new Color[]{startColor, endColor};
                int idx = 0;
                int delta = 10;
                if (orientation == 0) {
                    float offset = r.x;
                    while (offset - (float)r.x < (float)r.width) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(offset, yOffset, delta, pHeight));
                        offset += (float)delta;
                    }
                } else {
                    float offset = r.y;
                    while (offset - (float)r.y < (float)r.height) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(xOffset, offset, delta, pWidth));
                        offset += (float)delta;
                    }
                }
            } else {
                Shape shape;
                int step = 6;
                if (orientation == 0) {
                    shape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                    yOffset = r.y + pHeight / 2;
                    g2.setPaint(new GradientPaint(r.x + this.getAnimationIndex() * step * 2, yOffset, startColor, r.x + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, yOffset, endColor, true));
                } else {
                    shape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                    xOffset = r.x + pWidth / 2;
                    g2.setPaint(new GradientPaint(xOffset, r.y + this.getAnimationIndex() * step * 2, startColor, xOffset, r.y + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, endColor, true));
                }
                g2.fill(shape);
            }
            if (this.progressBar.isStringPainted()) {
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.x, this.boxRect.width);
                } else {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.y, this.boxRect.height);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected static boolean hasPassed(JComponent c) {
        return PropertyUtil.getBooleanProperty(c, KEY_PASSED);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        UIManager.put("ProgressBar.repaintInterval", DarkProgressBarUI.isSimplified() ? 500 : 50);
        UIManager.put("ProgressBar.cycleTime", DarkProgressBarUI.isSimplified() ? 1000 : 800);
        this.trackColor = UIManager.getColor("ProgressBar.trackColor");
        this.progressColor = UIManager.getColor("ProgressBar.progressColor");
        this.indeterminateStartColor = UIManager.getColor("ProgressBar.indeterminateStartColor");
        this.indeterminateEndColor = UIManager.getColor("ProgressBar.indeterminateEndColor");
        this.stripeWidth = UIManager.getInt("ProgressBar.stripeWidth");
        this.failedColor = UIManager.getColor("ProgressBar.failedColor");
        this.failedEndColor = UIManager.getColor("ProgressBar.failedEndColor");
        this.passedColor = UIManager.getColor("ProgressBar.passedColor");
        this.passedEndColor = UIManager.getColor("ProgressBar.passedEndColor");
    }

    protected Color getStartColor() {
        return this.indeterminateStartColor;
    }

    protected Color getEndColor() {
        return this.indeterminateEndColor;
    }

    private Shape getShapedRect(float x, float y, float w, float h, float ar) {
        return new RoundRectangle2D.Float(x, y, w, h, ar, ar);
    }

    private void paintString(Graphics2D g, int x, int y, int w, int h, int fillStart, int amountFull) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        String progressString = this.progressBar.getString();
        g.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
        g.setColor(this.getSelectionBackground());
        if (this.progressBar.getOrientation() == 0) {
            g.drawString(progressString, renderLocation.x, renderLocation.y);
            g.clipRect(fillStart, y, amountFull, h);
        } else {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
            g.clipRect(x, fillStart, w, amountFull);
        }
        g.setColor(this.getSelectionForeground());
        g.drawString(progressString, renderLocation.x, renderLocation.y);
        config.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Shape coloredShape;
            Shape fullShape;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque() && c.getParent() != null) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i = this.progressBar.getInsets();
            DarkUIUtil.applyInsets(r, i);
            int amountFull = this.getAmountFull(i, r.width, r.height);
            int orientation = this.progressBar.getOrientation();
            if (orientation == 0) {
                int pHeight = this.progressBar.getPreferredSize().height;
                int yOffset = r.y + (r.height - pHeight) / 2;
                fullShape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                coloredShape = this.progressBar.getComponentOrientation().isLeftToRight() ? this.getShapedRect(r.x, yOffset, amountFull, pHeight, pHeight) : this.getShapedRect(r.x + r.width - amountFull, yOffset, amountFull, pHeight, pHeight);
            } else {
                int pWidth = this.progressBar.getPreferredSize().width;
                int xOffset = r.x + (r.width - pWidth) / 2;
                fullShape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                coloredShape = this.progressBar.getComponentOrientation().isLeftToRight() ? this.getShapedRect(xOffset, r.y, pWidth, amountFull, pWidth) : this.getShapedRect(xOffset, r.y + r.height - amountFull, pWidth, amountFull, pWidth);
            }
            g2.setColor(this.getRemainderColor());
            g2.fill(fullShape);
            if (DarkProgressBarUI.hasFailed(this.progressBar)) {
                g2.setColor(this.failedColor);
            } else if (DarkProgressBarUI.hasPassed(this.progressBar)) {
                g2.setColor(this.passedColor);
            } else {
                g2.setColor(this.getFinishedColor());
            }
            g2.fill(coloredShape);
            if (this.progressBar.isStringPainted()) {
                GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
                Rectangle progressRect = coloredShape.getBounds();
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, progressRect.x, progressRect.x + progressRect.width);
                } else {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, progressRect.y, progressRect.y + progressRect.height);
                }
                config.restore();
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getRemainderColor() {
        return this.trackColor;
    }

    protected Color getFinishedColor() {
        return this.progressColor;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (!(c instanceof JProgressBar)) {
            return size;
        }
        if (!((JProgressBar)c).isStringPainted()) {
            if (((JProgressBar)c).getOrientation() == 0) {
                size.height = this.getStripeWidth();
            } else {
                size.width = this.getStripeWidth();
            }
        }
        return size;
    }

    private int getStripeWidth() {
        return this.stripeWidth;
    }

    private static boolean isSimplified() {
        return UIManager.getBoolean("ProgressBar.isSimplified");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_FAILED.equals(key) || KEY_PASSED.equals(key)) {
            this.progressBar.repaint();
        } else if ("componentOrientation".equals(key) || "stringPainted".equals(key)) {
            this.progressBar.revalidate();
        }
    }
}

