/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import com.github.weisj.darklaf.icons.ToggleIcon;
import com.github.weisj.darklaf.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class DarkInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements PropertyChangeListener {
    protected static final int PAD = 5;
    protected static final int IMAGE_HEIGHT = 16;
    protected static final int IMAGE_WIDTH = 16;
    private JMenuBar menu;
    private JLabel label;
    private Color border;
    private Color buttonColor;
    private Color selectedButtonColor;
    private Color buttonColorClick;
    private Color buttonColorHover;
    private Color selectedButtonColorHover;
    private Color selectedButtonColorClick;
    private ToggleIcon minimizeIcon;
    private ToggleIcon maximizeIcon;
    private ToggleIcon iconifyIcon;
    private int buttonMarginPad;
    private int minHeight;
    private boolean useExternalMenuBar;
    private boolean unifiedMenuBar;

    public DarkInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected void addSubComponents() {
        super.addSubComponents();
        this.label = this.createTitleLabel();
        this.addMenuBar(this.frame.getJMenuBar());
        this.add(this.label);
    }

    protected JLabel createTitleLabel() {
        JLabel label = new JLabel();
        label.setOpaque(false);
        return label;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.useExternalMenuBar = UIManager.getBoolean("InternalFrame.useExternalMenuBar");
        this.unifiedMenuBar = UIManager.getBoolean("TitlePane.unifiedMenuBar");
        if (!this.useExternalMenuBar) {
            this.frame.addPropertyChangeListener("JMenuBar", this);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.closeIcon = UIManager.getIcon("InternalFrameTitlePane.close.icon");
        this.minimizeIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.minimize.icon"), UIManager.getIcon("InternalFrameTitlePane.minimize.disabled.icon"));
        this.maximizeIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.maximize.icon"), UIManager.getIcon("InternalFrameTitlePane.maximize.disabled.icon"));
        this.iconifyIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.iconify.icon"), UIManager.getIcon("InternalFrameTitlePane.iconify.disabled.icon"));
        this.minIcon = this.minimizeIcon;
        this.maxIcon = this.maximizeIcon;
        this.iconIcon = this.iconifyIcon;
        this.selectedTitleColor = UIManager.getColor("InternalFrameTitlePane.selectedBackgroundColor");
        this.selectedTextColor = UIManager.getColor("InternalFrameTitlePane.selectedTextForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrameTitlePane.backgroundColor");
        this.notSelectedTextColor = UIManager.getColor("InternalFrameTitlePane.textForeground");
        this.selectedButtonColor = UIManager.getColor("InternalFrameTitlePane.selectedButtonColor");
        this.selectedButtonColorHover = UIManager.getColor("InternalFrameTitlePane.selectedButtonHoverColor");
        this.selectedButtonColorClick = UIManager.getColor("InternalFrameTitlePane.selectedButtonClickColor");
        this.buttonColor = UIManager.getColor("InternalFrameTitlePane.buttonColor");
        this.buttonColorHover = UIManager.getColor("InternalFrameTitlePane.buttonHoverColor");
        this.buttonColorClick = UIManager.getColor("InternalFrameTitlePane.buttonClickColor");
        this.border = UIManager.getColor("InternalFrameTitlePane.borderColor");
        this.buttonMarginPad = UIManager.getInt("InternalFrameTitlePane.buttonPad");
        this.minHeight = UIManager.getInt("InternalFrameTitlePane.minimumHeight");
    }

    @Override
    protected void createButtons() {
        this.iconButton = this.createButton(this.iconifyAction);
        this.maxButton = this.createButton(this.maximizeAction);
        this.maxButton.addActionListener(e -> {
            if (this.maximizeAction.isEnabled()) {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(false);
                this.maxButton.setAction(this.restoreAction);
            } else {
                this.restoreAction.setEnabled(false);
                this.maximizeAction.setEnabled(true);
                this.maxButton.setAction(this.maximizeAction);
            }
            this.maxButton.putClientProperty("AccessibleName", this.maxButton.getText());
            this.maxButton.setText(null);
        });
        this.closeButton = this.createButton(this.closeAction);
        this.setButtonIcons();
    }

    @Override
    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = systemMenu.add(this.restoreAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("restore"));
        mi.setIcon(this.minimizeIcon);
        mi.setDisabledIcon(this.minimizeIcon);
        mi = systemMenu.add(this.iconifyAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("minimize"));
        mi.setIcon(this.iconifyIcon);
        mi.setDisabledIcon(this.iconifyIcon);
        mi = systemMenu.add(this.maximizeAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("maximize"));
        mi.setIcon(this.maximizeIcon);
        mi.setDisabledIcon(this.maximizeIcon);
        systemMenu.addSeparator();
        mi = systemMenu.add(this.closeAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("close"));
        mi.setIcon(this.closeIcon);
    }

    @Override
    protected void createActions() {
        super.createActions();
        Locale l = this.getLocale();
        this.maximizeAction.putValue("Name", UIManager.getString((Object)"Actions.maximize", l));
        this.maximizeAction.putValue("ShortDescription", UIManager.getString((Object)"Actions.maximize", l));
        this.maximizeAction.putValue("SmallIcon", this.maximizeIcon);
        this.closeAction.putValue("Name", UIManager.getString((Object)"Actions.close", l));
        this.closeAction.putValue("ShortDescription", UIManager.getString((Object)"Actions.close", l));
        this.closeAction.putValue("SmallIcon", this.closeIcon);
        this.iconifyAction.putValue("Name", UIManager.getString((Object)"Actions.minimize", l));
        this.iconifyAction.putValue("ShortDescription", UIManager.getString((Object)"Actions.minimize", l));
        this.iconifyAction.putValue("SmallIcon", this.minimizeIcon);
        this.restoreAction.putValue("Name", UIManager.getString((Object)"Actions.restore", l));
        this.restoreAction.putValue("ShortDescription", UIManager.getString((Object)"Actions.restore", l));
        this.restoreAction.putValue("SmallIcon", this.iconifyIcon);
    }

    private static int getButtonMnemonic(String button) {
        try {
            return Integer.parseInt(UIManager.getString("InternalFrameTitlePane." + button + "Button.mnemonic"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getTitleBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void enableActions() {
        super.enableActions();
        this.iconifyIcon.setActive(this.iconifyAction.isEnabled());
        this.maximizeIcon.setActive(this.maximizeAction.isEnabled());
        this.minimizeIcon.setActive(this.restoreAction.isEnabled());
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarkTitlePaneLayout();
    }

    protected Color getTitleBackground() {
        return this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor;
    }

    private JButton createButton(Action action) {
        JButtonUIResource button = new JButtonUIResource(action){

            @Override
            public boolean isRolloverEnabled() {
                return true;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(button);
        button.setFocusable(false);
        button.setOpaque(true);
        button.putClientProperty("JButton.variant", "borderless");
        button.putClientProperty("JButton.square", true);
        button.putClientProperty("JButton.thin", true);
        button.putClientProperty("JToolTip.style", ToolTipStyle.PLAIN);
        button.setMargin(new Insets(this.buttonMarginPad, this.buttonMarginPad, this.buttonMarginPad, this.buttonMarginPad));
        button.putClientProperty("AccessibleName", button.getText());
        button.setText(null);
        return button;
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.label.setText(this.frame.getTitle());
        Color colorClick = this.frame.isSelected() ? this.selectedButtonColorClick : this.buttonColorClick;
        Color colorHover = this.frame.isSelected() ? this.selectedButtonColorHover : this.buttonColorHover;
        Color bg = this.frame.isSelected() ? this.selectedButtonColor : this.buttonColor;
        this.iconButton.setBackground(bg);
        this.closeButton.setBackground(bg);
        this.maxButton.setBackground(bg);
        if (this.menu != null) {
            this.menu.setBackground(bg);
            this.menu.setOpaque(false);
        }
        this.iconButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.closeButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.maxButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.iconButton.putClientProperty("JButton.borderless.click", colorClick);
        this.closeButton.putClientProperty("JButton.borderless.click", colorClick);
        this.maxButton.putClientProperty("JButton.borderless.click", colorClick);
        super.paintChildren(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(this.border);
        g.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object menuBar = e.getNewValue();
        if (menuBar instanceof JMenuBar) {
            this.addMenuBar((JMenuBar)menuBar);
        }
    }

    protected void addMenuBar(JMenuBar menuBar) {
        if (!this.unifiedMenuBar && !this.useExternalMenuBar) {
            return;
        }
        this.menu = menuBar;
        this.frame.getRootPane().setJMenuBar(null);
        if (this.menu != null) {
            this.add(this.menu);
        }
    }

    @Override
    protected JMenuBar createSystemMenuBar() {
        return new DarkSystemMenuBar();
    }

    protected class DarkTitlePaneLayout
    implements LayoutManager {
        protected DarkTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int titleLength;
            String frameTitle;
            Dimension pref;
            int width = 10;
            Icon icon = DarkInternalFrameTitlePane.this.frame.getFrameIcon();
            FontMetrics fm = DarkInternalFrameTitlePane.this.label.getFontMetrics(DarkInternalFrameTitlePane.this.label.getFont());
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16) + 2;
            }
            int height = Math.max(fm.getHeight() + 2, iconHeight);
            if (DarkInternalFrameTitlePane.this.menu != null) {
                height = Math.max(height, ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).menu.getPreferredSize().height);
            }
            height = Math.max(DarkInternalFrameTitlePane.this.minHeight, height);
            if (DarkInternalFrameTitlePane.this.frame.isClosable()) {
                pref = DarkInternalFrameTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(height, pref.height);
            }
            if (DarkInternalFrameTitlePane.this.frame.isMaximizable()) {
                pref = DarkInternalFrameTitlePane.this.maxButton.getPreferredSize();
                width += pref.width;
                height = Math.max(height, pref.height);
            }
            if (DarkInternalFrameTitlePane.this.frame.isIconifiable()) {
                pref = DarkInternalFrameTitlePane.this.iconButton.getPreferredSize();
                width += pref.width;
                height = Math.max(height, pref.height);
            }
            int titleWidth = (frameTitle = DarkInternalFrameTitlePane.this.frame.getTitle()) != null ? SwingUtil.stringWidth(DarkInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = titleLength = frameTitle != null ? frameTitle.length() : 0;
            if (titleLength > 3) {
                int subtitle_w = SwingUtil.stringWidth(DarkInternalFrameTitlePane.this.frame, fm, frameTitle.substring(0, 3) + "...");
                width += Math.min(titleWidth, subtitle_w);
            } else {
                width += titleWidth;
            }
            if (DarkInternalFrameTitlePane.this.menu != null) {
                width += ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).menu.getPreferredSize().width + 5;
            }
            Dimension dim = new Dimension(width, height);
            if (DarkInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = DarkInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        protected boolean useExternalMenuBar() {
            return DarkInternalFrameTitlePane.this.useExternalMenuBar;
        }

        @Override
        public void layoutContainer(Container c) {
            boolean useExternalMenuBar = this.useExternalMenuBar();
            int w = DarkInternalFrameTitlePane.this.getWidth();
            int h = DarkInternalFrameTitlePane.this.getHeight() - 1;
            if (!useExternalMenuBar) {
                Icon icon = DarkInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = icon.getIconHeight();
                }
                int x1 = 5;
                DarkInternalFrameTitlePane.this.menuBar.setBounds(x1, (h - iconHeight) / 2, 16, 16);
                x1 += 16;
                x1 += 5;
                if (DarkInternalFrameTitlePane.this.menu != null) {
                    int width = ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).menu.getPreferredSize().width;
                    DarkInternalFrameTitlePane.this.menu.setBounds(x1, 0, width, h + 1);
                    x1 += width + 5;
                }
                int x2 = w;
                if (DarkInternalFrameTitlePane.this.frame.isClosable()) {
                    Dimension pref = DarkInternalFrameTitlePane.this.closeButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.closeButton.setBounds(x2 -= pref.width, (h - pref.height) / 2, pref.width, pref.height);
                }
                if (DarkInternalFrameTitlePane.this.frame.isMaximizable()) {
                    Dimension pref = DarkInternalFrameTitlePane.this.maxButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.maxButton.setBounds(x2 -= pref.width, (h - pref.height) / 2, pref.width, pref.height);
                }
                if (DarkInternalFrameTitlePane.this.frame.isIconifiable()) {
                    Dimension pref = DarkInternalFrameTitlePane.this.iconButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.iconButton.setBounds(x2 -= pref.width, (h - pref.height) / 2, pref.width, pref.height);
                }
                DarkInternalFrameTitlePane.this.label.setBounds(x1, 0, (x2 -= 5) - x1, h);
            } else {
                Dimension pref;
                int x2 = 0;
                if (DarkInternalFrameTitlePane.this.frame.isClosable()) {
                    pref = DarkInternalFrameTitlePane.this.closeButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.closeButton.setBounds(x2, (h - pref.height) / 2, pref.width, pref.height);
                    x2 += pref.width;
                }
                if (DarkInternalFrameTitlePane.this.frame.isIconifiable()) {
                    pref = DarkInternalFrameTitlePane.this.iconButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.iconButton.setBounds(x2, (h - pref.height) / 2, pref.width, pref.height);
                    x2 += pref.width;
                }
                if (DarkInternalFrameTitlePane.this.frame.isMaximizable()) {
                    pref = DarkInternalFrameTitlePane.this.maxButton.getPreferredSize();
                    DarkInternalFrameTitlePane.this.maxButton.setBounds(x2, (h - pref.height) / 2, pref.width, pref.height);
                    x2 += pref.width;
                }
                x2 += 5;
                Icon icon = DarkInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = icon.getIconHeight();
                }
                int midWidth = Math.min(w - x2, 16 + ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).label.getPreferredSize().width);
                int x1 = (w - midWidth) / 2;
                DarkInternalFrameTitlePane.this.menuBar.setBounds(x1, (h - iconHeight) / 2, 16, 16);
                DarkInternalFrameTitlePane.this.label.setBounds(x1 += 16, 0, midWidth - 16, h);
            }
        }
    }

    protected class DarkSystemMenuBar
    extends BasicInternalFrameTitlePane.SystemMenuBar {
        protected DarkSystemMenuBar() {
            super(DarkInternalFrameTitlePane.this);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }
}

