/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.components.DefaultColorPipette;
import com.github.weisj.darklaf.listener.AncestorAdapter;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorPipette;
import com.github.weisj.darklaf.ui.colorchooser.ColorPreviewComponent;
import com.github.weisj.darklaf.ui.colorchooser.ColorValueFormatter;
import com.github.weisj.darklaf.ui.colorchooser.ColorWheelPanel;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.AncestorEvent;

public class DarkColorChooserPanel
extends AbstractColorChooserPanel
implements ColorListener {
    public static final String TRANSPARENCY_ENABLED_PROPERTY = "transparency";
    private final Icon pipetteIcon;
    private final Icon pipetteHoverIcon;
    private final ColorPipette pipette;
    private final ColorWheelPanel colorWheelPanel;
    private final ColorPreviewComponent previewComponent;
    private JFormattedTextField[] valueFields;
    private ColorValueFormatter[] formatters;
    private JLabel[] descriptors;
    private JLabel[] descriptorsAfter;
    private JFormattedTextField textHex;
    private ColorValueFormatter hexFormatter;
    private final JComboBox<DarkColorModel> formatBox;
    private Color currentColor;
    protected boolean isChanging;

    public DarkColorChooserPanel(DarkColorModel ... colorModels) {
        if (colorModels == null || colorModels.length == 0) {
            throw new IllegalArgumentException("Must pass at least one valid colorModel");
        }
        this.isChanging = true;
        this.previewComponent = new ColorPreviewComponent();
        this.colorWheelPanel = new ColorWheelPanel(true, true);
        this.pipette = new DefaultColorPipette(this, this.colorWheelPanel::setColor);
        this.pipetteIcon = UIManager.getIcon("ColorChooser.pipette.icon");
        this.pipetteHoverIcon = UIManager.getIcon("ColorChooser.pipetteRollover.icon");
        this.formatBox = this.createColorFormatChooser(colorModels);
        this.initInputFields(colorModels);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 21));
        this.add((Component)this.buildTopPanel(UIManager.getBoolean("ColorChooser.pipetteEnabled")), "North");
        this.add((Component)this.colorWheelPanel, "Center");
        this.add(Box.createVerticalStrut(10), "South");
        this.installListeners();
    }

    @Override
    protected void buildChooser() {
        this.isChanging = false;
        this.onModelChange();
        this.colorChanged(this.getColorFromModel(), this);
    }

    protected void installListeners() {
        this.formatBox.addActionListener(e -> this.onModelChange());
        this.textHex.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DarkColorChooserPanel.this.textHex.requestFocusInWindow();
                DarkColorChooserPanel.this.textHex.removeAncestorListener(this);
            }
        });
        this.textHex.getDocument().addDocumentListener(() -> this.colorChanged(this.getColorFromHex(), this.textHex));
        for (JFormattedTextField inputField : this.valueFields) {
            inputField.addPropertyChangeListener(e -> {
                if ("value".equals(e.getPropertyName())) {
                    this.colorChanged(this.getColorFromFields(), inputField);
                }
            });
        }
        this.colorWheelPanel.addListener(this);
    }

    protected Color getColorFromHex() {
        try {
            String hexStr = String.format("%1$-8s", this.textHex.getText()).replaceAll(" ", "F");
            int alpha = this.isColorTransparencySelectionEnabled() ? Integer.valueOf(hexStr.substring(6, 8), 16) : 255;
            return new Color(Integer.valueOf(hexStr.substring(0, 2), 16), Integer.valueOf(hexStr.substring(2, 4), 16), Integer.valueOf(hexStr.substring(4, 6), 16), alpha);
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            return null;
        }
    }

    protected Color getColorFromFields() {
        DarkColorModel model = this.getDarkColorModel();
        int[] values = new int[model.getCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Integer)this.valueFields[i].getValue();
        }
        Color c = model.getColorFromValues(values);
        if (this.isColorTransparencySelectionEnabled()) {
            c = ColorUtil.toAlpha(c, this.getColorFromModel().getAlpha());
        }
        return c;
    }

    @Override
    public void colorChanged(Color color, Object source) {
        if (this.isChanging || color == null) {
            return;
        }
        this.isChanging = true;
        this.currentColor = color;
        ColorSelectionModel model = this.getColorSelectionModel();
        if (model != null) {
            model.setSelectedColor(this.currentColor);
        }
        this.applyColorToFields(color);
        if (source != this.textHex) {
            this.textHex.setValue(color);
        }
        this.previewComponent.setColor(color);
        this.colorWheelPanel.setColor(color, this);
        this.isChanging = false;
    }

    protected void onModelChange() {
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        this.colorWheelPanel.setModel(this.getDarkColorModel());
        this.updateDescriptors();
        this.toggleValueFields();
        this.updateFormatters();
        this.applyColorToFields(this.getColorFromModel());
        this.doLayout();
        this.isChanging = false;
    }

    protected void applyColorToFields(Color color) {
        DarkColorModel model = this.getDarkColorModel();
        int[] values = model.getValuesFromColor(color);
        for (int i = 0; i < values.length; ++i) {
            this.valueFields[i].setValue(values[i]);
        }
    }

    public void initInputFields(DarkColorModel[] colorModels) {
        int record = this.getMaxFieldCount(colorModels);
        this.descriptors = new JLabel[record];
        this.descriptorsAfter = new JLabel[record];
        this.textHex = this.createColorField(true);
        this.hexFormatter = ColorValueFormatter.init(this.getDarkColorModel(), 0, true, this.textHex);
        this.hexFormatter.setTransparencyEnabled(this.isColorTransparencySelectionEnabled());
        this.valueFields = new JFormattedTextField[record];
        this.formatters = new ColorValueFormatter[record];
        for (int i = 0; i < record; ++i) {
            this.descriptors[i] = new JLabel();
            this.descriptorsAfter[i] = new JLabel();
            this.valueFields[i] = this.createColorField(false);
            this.formatters[i] = ColorValueFormatter.init(this.getDarkColorModel(), i, false, this.valueFields[i]);
        }
    }

    private JFormattedTextField createColorField(boolean hex) {
        JFormattedTextField field = new JFormattedTextField((Object)0);
        field.setColumns(hex ? 8 : 3);
        field.setFocusLostBehavior(1);
        return field;
    }

    protected int getMaxFieldCount(DarkColorModel[] colorModels) {
        int record = 0;
        for (DarkColorModel model : colorModels) {
            record = Math.max(model.getCount(), record);
        }
        return record;
    }

    protected JComboBox<DarkColorModel> createColorFormatChooser(DarkColorModel[] colorModels) {
        JComboBox<DarkColorModel> comboBox = new JComboBox<DarkColorModel>(colorModels);
        DarkColorModel prototype = null;
        for (DarkColorModel model : colorModels) {
            String name = model.toString();
            if (prototype != null && prototype.toString().length() >= name.length()) continue;
            prototype = model;
        }
        comboBox.setPrototypeDisplayValue(prototype);
        return comboBox;
    }

    private void updateDescriptors() {
        String[] desc = this.getDarkColorModel().getLabelDescriptorsBefore();
        String[] descAfter = this.getDarkColorModel().getFullLabelDescriptorsAfter();
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (i < desc.length) {
                this.descriptors[i].setText(desc[i] + ":");
            } else {
                this.descriptors[i].setText("");
            }
            if (i < descAfter.length) {
                this.descriptorsAfter[i].setText(descAfter[i]);
                continue;
            }
            this.descriptorsAfter[i].setText("");
        }
    }

    private void toggleValueFields() {
        DarkColorModel model = this.getDarkColorModel();
        int count = model.getCount();
        for (int i = 0; i < this.valueFields.length; ++i) {
            this.valueFields[i].setEnabled(i < count);
            this.valueFields[i].setVisible(i < count);
        }
    }

    private void updateFormatters() {
        for (ColorValueFormatter formatter : this.formatters) {
            formatter.setModel(this.getDarkColorModel());
        }
    }

    @Override
    protected Color getColorFromModel() {
        Color c = super.getColorFromModel();
        return c == null ? this.currentColor : c;
    }

    protected DarkColorModel getDarkColorModel() {
        return (DarkColorModel)this.formatBox.getSelectedItem();
    }

    private JComponent buildTopPanel(boolean enablePipette) {
        JPanel result = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        if (enablePipette && this.pipette != null) {
            previewPanel.add((Component)this.createPipetteButton(), "West");
        }
        this.previewComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.previewComponent.setPreferredSize(new Dimension(100, 25));
        previewPanel.add((Component)this.previewComponent, "Center");
        result.add((Component)previewPanel, "North");
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel, 0));
        valuePanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        for (int i = 0; i < this.descriptorsAfter.length; ++i) {
            this.descriptorsAfter[i].setPreferredSize(new Dimension(14, -1));
            this.descriptors[i].setPreferredSize(new Dimension(14, -1));
            valuePanel.add(this.descriptors[i]);
            valuePanel.add(this.valueFields[i]);
            valuePanel.add(this.descriptorsAfter[i]);
            if (i >= this.descriptorsAfter.length - 1) continue;
            valuePanel.add(Box.createHorizontalStrut(2));
        }
        result.add((Component)valuePanel, "West");
        JPanel hexPanel = new JPanel();
        hexPanel.setLayout(new BoxLayout(hexPanel, 0));
        hexPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        hexPanel.add(this.formatBox);
        hexPanel.add(Box.createHorizontalStrut(2));
        hexPanel.add(new JLabel("#"));
        hexPanel.add(this.textHex);
        result.add((Component)hexPanel, "East");
        return result;
    }

    private JButton createPipetteButton() {
        JButton pipetteButton = new JButton();
        pipetteButton.putClientProperty("JButton.square", Boolean.TRUE);
        pipetteButton.setRolloverEnabled(true);
        pipetteButton.setFocusable(false);
        pipetteButton.setIcon(this.getPipetteIcon());
        pipetteButton.setRolloverIcon(this.getPipetteRolloverIcon());
        pipetteButton.setDisabledIcon(this.getPipetteRolloverIcon());
        pipetteButton.setPressedIcon(this.getPipetteRolloverIcon());
        pipetteButton.addActionListener(e -> {
            pipetteButton.setEnabled(false);
            this.pipette.setInitialColor(this.getColorFromModel());
            this.pipette.show();
        });
        ((DefaultColorPipette)this.pipette).setCloseAction(() -> pipetteButton.setEnabled(true));
        return pipetteButton;
    }

    @Override
    public boolean isColorTransparencySelectionEnabled() {
        return this.colorWheelPanel.isColorTransparencySelectionEnabled();
    }

    @Override
    public void setColorTransparencySelectionEnabled(boolean b) {
        boolean oldValue = this.isColorTransparencySelectionEnabled();
        if (b != oldValue) {
            this.hexFormatter.setTransparencyEnabled(b);
            this.colorWheelPanel.setColorTransparencySelectionEnabled(b);
            if (b && this.getColorFromModel().getAlpha() < 255) {
                this.colorChanged(ColorUtil.removeAlpha(this.getColorFromModel()), this);
            }
            this.firePropertyChange(TRANSPARENCY_ENABLED_PROPERTY, oldValue, b);
        }
    }

    protected Icon getPipetteIcon() {
        return this.pipetteIcon;
    }

    protected Icon getPipetteRolloverIcon() {
        return this.pipetteHoverIcon;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(520, 420);
    }

    @Override
    public void updateChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString((Object)"ColorChooser.wheelNameText", this.getLocale());
    }

    @Override
    public int getMnemonic() {
        return PropertyUtil.getMnemonic("ColorChooser.wheelLabelMnemonic", this.getLocale());
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return 6;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

