/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.delegate.AbstractButtonLayoutDelegate;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.graphics.StringPainter;
import com.github.weisj.darklaf.swingdsl.VisualPaddingListener;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonBorder;
import com.github.weisj.darklaf.ui.button.DarkButtonListener;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonFocusNavigationActions;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import com.github.weisj.darklaf.util.value.CleanupTask;
import com.github.weisj.darklaf.util.value.WeakShared;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class DarkButtonUI
extends BasicButtonUI
implements ButtonConstants {
    protected static final RoundRectangle2D hitArea = new RoundRectangle2D.Float();
    private static final WeakShared<AbstractButtonLayoutDelegate> sharedLayoutDelegate = new WeakShared<AbstractButtonLayoutDelegate>(ButtonLayoutDelegate::new);
    protected AbstractButtonLayoutDelegate layoutDelegate;
    protected boolean isDefaultButton = false;
    protected final Rectangle viewRect = new Rectangle();
    protected final Rectangle textRect = new Rectangle();
    protected final Rectangle iconRect = new Rectangle();
    protected String displayText;
    protected int borderSize;
    protected int shadowHeight;
    protected boolean drawOutline;
    protected Color inactiveForeground;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Color defaultHoverBackground;
    protected Color defaultClickBackground;
    protected Color background;
    protected Color hoverBackground;
    protected Color clickBackground;
    protected Color inactiveBackground;
    protected Color borderlessHover;
    protected Color borderlessClick;
    protected Color borderlessOutlineHover;
    protected Color borderlessOutlineClick;
    protected Color shadowColor;
    protected Insets insets;
    protected Insets thinInsets;
    protected Insets squareInsets;
    protected Insets squareThinInsets;
    protected Insets borderlessRectangularInsets;
    protected AbstractButton button;
    protected int arc;
    protected int altArc;
    protected ToggleButtonFocusNavigationActions keyboardActions;
    protected VisualPaddingListener visualPaddingListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.button = (AbstractButton)c;
        this.layoutDelegate = sharedLayoutDelegate.get();
        super.installUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setLayout(this.createLayout());
        PropertyUtil.installProperty(b, "JToolTip.style", ToolTipStyle.parse(UIManager.get("Button.toolTipStyle")));
        LookAndFeel.installProperty(b, "opaque", false);
        this.borderSize = UIManager.getInt("Button.borderThickness");
        this.shadowHeight = UIManager.getInt("Button.shadowHeight");
        this.shadowColor = UIManager.getColor("Button.shadow");
        this.inactiveForeground = UIManager.getColor("Button.disabledText");
        this.defaultForeground = UIManager.getColor("Button.selectedButtonForeground");
        this.defaultBackground = UIManager.getColor("Button.defaultFillColor");
        this.defaultHoverBackground = UIManager.getColor("Button.defaultFillColorRollOver");
        this.defaultClickBackground = UIManager.getColor("Button.defaultFillColorClick");
        this.background = UIManager.getColor("Button.activeFillColor");
        this.hoverBackground = UIManager.getColor("Button.activeFillColorRollOver");
        this.clickBackground = UIManager.getColor("Button.activeFillColorClick");
        this.inactiveBackground = UIManager.getColor("Button.inactiveFillColor");
        this.borderlessHover = UIManager.getColor("Button.borderless.hover");
        this.borderlessClick = UIManager.getColor("Button.borderless.click");
        this.borderlessOutlineHover = UIManager.getColor("Button.borderless.outline.hover");
        this.borderlessOutlineClick = UIManager.getColor("Button.borderless.outline.click");
        this.arc = UIManager.getInt("Button.arc");
        this.altArc = UIManager.getInt("Button.altArc");
        this.drawOutline = UIManager.getBoolean("Button.borderless.drawOutline");
        this.insets = UIManager.getInsets("Button.borderInsets");
        this.thinInsets = UIManager.getInsets("Button.thinBorderInsets");
        this.squareInsets = UIManager.getInsets("Button.squareBorderInsets");
        this.squareThinInsets = UIManager.getInsets("Button.squareThinBorderInsets");
        this.borderlessRectangularInsets = UIManager.getInsets("Button.borderlessRectangularInsets");
        if (this.insets == null) {
            this.insets = new Insets(0, 0, 0, 0);
        }
        if (this.thinInsets == null) {
            this.thinInsets = new Insets(0, 0, 0, 0);
        }
        if (this.squareThinInsets == null) {
            this.squareThinInsets = new Insets(0, 0, 0, 0);
        }
        if (this.squareInsets == null) {
            this.squareInsets = new Insets(0, 0, 0, 0);
        }
        if (this.borderlessRectangularInsets == null) {
            this.borderlessRectangularInsets = new Insets(0, 0, 0, 0);
        }
        this.updateMargins(b);
    }

    protected LayoutManager createLayout() {
        return new DarkButtonLayout();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.keyboardActions = new ToggleButtonFocusNavigationActions(b);
        this.keyboardActions.installActions();
        this.visualPaddingListener = new VisualPaddingListener();
        b.addPropertyChangeListener(this.visualPaddingListener);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new DarkButtonListener<DarkButtonUI>(b, this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.layoutDelegate = null;
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setLayout(null);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        this.keyboardActions.uninstallActions();
        this.keyboardActions = null;
        b.removePropertyChangeListener(this.visualPaddingListener);
        this.visualPaddingListener = null;
    }

    protected void validateLayout() {
        boolean defButton = ButtonConstants.isDefaultButton(this.button);
        if (defButton != this.isDefaultButton) {
            this.isDefaultButton = defButton;
            this.button.doLayout();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.validateLayout();
        GraphicsContext config = new GraphicsContext(g);
        AbstractButton b = (AbstractButton)c;
        try (CleanupTask clean = this.prepareDelegate(b);){
            this.paintButtonBackground(g, c);
            this.paintIcon(g, b, c);
            config.restoreClip();
            this.paintText(g, b, this.displayText);
        }
    }

    protected void paintButtonBackground(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        if (this.shouldDrawBackground(b)) {
            int arc = this.getArc(c);
            int width = c.getWidth();
            int height = c.getHeight();
            Insets margin = b.getMargin();
            if (margin instanceof UIResource) {
                margin = null;
            }
            if (ButtonConstants.isBorderlessVariant(c)) {
                this.paintBorderlessBackground(b, g2, arc, width, height, margin);
            } else if (b.getBorder() instanceof DarkButtonBorder) {
                this.paintDarklafBorderBackground(b, g2, arc, width, height);
            } else {
                this.paintDefaultBackground(b, g2, width, height);
            }
        }
    }

    protected void paintDefaultBackground(AbstractButton b, Graphics2D g, int width, int height) {
        Insets ins = b.getInsets();
        g.setColor(this.getBackgroundColor(b));
        PaintUtil.fillRect(g, ins.left, ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom);
    }

    protected void paintDarklafBorderBackground(AbstractButton c, Graphics2D g, int arc, int width, int height) {
        boolean showShadow = DarkButtonBorder.showDropShadow(c);
        int shadow = showShadow ? this.shadowHeight : 0;
        int effectiveArc = ButtonConstants.chooseArcWithBorder(c, arc, 0, 0, this.borderSize);
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        Rectangle bgRect = this.getEffectiveRect(width, height, -(effectiveArc + 1), corner);
        this.paintDarklafBorderBgImpl(c, g, showShadow, shadow, effectiveArc, bgRect);
    }

    protected void paintDarklafBorderBgImpl(AbstractButton c, Graphics2D g, boolean showShadow, int shadow, int effectiveArc, Rectangle bgRect) {
        if (c.isEnabled() && showShadow && PaintUtil.getShadowComposite().getAlpha() != 0.0f) {
            this.paintShadow(g, shadow, effectiveArc, bgRect);
        }
        g.setColor(this.getBackgroundColor(c));
        this.paintBackgroundRect(g, effectiveArc, bgRect);
    }

    protected void paintShadow(Graphics2D g, int shadow, int effectiveArc, Rectangle bgRect) {
        g.setColor(this.shadowColor);
        Composite comp = g.getComposite();
        g.setComposite(PaintUtil.getShadowComposite());
        int stroke = (int)PaintUtil.getStrokeWidth(g);
        this.paintBackgroundRect(g, effectiveArc * 2, bgRect.x, bgRect.y + shadow + stroke, bgRect.width, bgRect.height);
        g.setComposite(comp);
    }

    protected void paintBackgroundRect(Graphics2D g2, int effectiveArc, Rectangle bgRect) {
        this.paintBackgroundRect(g2, effectiveArc, bgRect.x, bgRect.y, bgRect.width, bgRect.height);
    }

    protected void paintBackgroundRect(Graphics2D g2, int effectiveArc, int x, int y, int width, int height) {
        if (effectiveArc == 0) {
            g2.fillRect(x, y, width, height);
        } else {
            PaintUtil.fillRoundRect(g2, x, y, width, height, effectiveArc, false);
        }
    }

    protected Rectangle getEffectiveRect(int width, int height, int adjustment, AlignmentExt corner) {
        Insets insetMask = new Insets(this.borderSize, this.borderSize, Math.max(this.borderSize, this.shadowHeight), this.borderSize);
        if (corner != null) {
            insetMask = corner.maskInsets(insetMask, adjustment);
        }
        int bx = insetMask.left;
        int by = insetMask.top;
        int bw = width - insetMask.left - insetMask.right;
        int bh = height - insetMask.top - insetMask.bottom;
        return new Rectangle(bx, by, bw, bh);
    }

    protected void paintBorderlessBackground(AbstractButton b, Graphics2D g, int arc, int width, int height, Insets m) {
        if (this.isRolloverBorderless(b)) {
            Border border = b.getBorder();
            Insets ins = border != null ? border.getBorderInsets(b) : new Insets(0, 0, 0, 0);
            Insets margin = m;
            if (margin == null) {
                margin = new Insets(0, 0, 0, 0);
            } else {
                Rectangle r = this.iconRect.union(this.textRect);
                margin.left = r.x - margin.left;
                margin.right = width - (r.x + r.width + margin.right);
                margin.top = r.y - margin.top;
                margin.bottom = height - (r.y + r.height + margin.bottom);
            }
            int x = Math.max(ins.left, margin.left);
            int y = Math.max(ins.top, margin.top);
            int w = width - x - Math.max(ins.right, margin.right);
            int h = height - y - Math.max(ins.bottom, margin.bottom);
            GraphicsUtil.setupStrokePainting(g);
            if (ButtonConstants.isBorderlessRectangular(b)) {
                this.paintBorderlessRectangularBackgroundIml(b, g, x, y, w, h);
            } else if (ButtonConstants.isBorderless(b)) {
                this.paintBorderlessBackgroundImpl(b, g, arc, x, y, w, h);
            } else {
                int size = Math.min(w, h);
                this.paintBorderlessBackgroundImpl(b, g, arc, (width - size) / 2, (height - size) / 2, size, size);
            }
        }
    }

    protected void paintBorderlessRectangularBackgroundIml(AbstractButton b, Graphics2D g, int x, int y, int w, int h) {
        g.setColor(this.getBorderlessBackground(b));
        g.fillRect(x, y, w, h);
    }

    protected void paintBorderlessBackgroundImpl(AbstractButton b, Graphics2D g, int arc, int x, int y, int w, int h) {
        if (!this.drawOutline) {
            g.setColor(this.getBorderlessBackground(b));
            g.fillRoundRect(x, y, w, h, arc, arc);
        } else {
            g.setColor(this.getBorderlessOutline(b));
            PaintUtil.paintLineBorder(g, x, y, w, h, arc);
        }
    }

    public boolean isRolloverBorderless(AbstractButton b) {
        return b.isEnabled() && b.getModel().isRollover();
    }

    protected void paintText(Graphics g, AbstractButton b, String text) {
        ButtonModel model = b.getModel();
        g.setColor(this.getForeground(b));
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            mnemonicIndex = -1;
        }
        StringPainter.drawStringUnderlineCharAt(g, b, text, mnemonicIndex, this.textRect, this.layoutDelegate.getFont());
    }

    protected void paintIcon(Graphics g, AbstractButton b, JComponent c) {
        if (b.getIcon() != null) {
            g.clipRect(this.iconRect.x, this.iconRect.y, this.iconRect.width, this.iconRect.height);
            this.paintIcon(g, c, this.iconRect);
        }
    }

    protected void repaintNeighbours() {
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.leftNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.topNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.topRightNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.topLeftNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.rightNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.bottomNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.bottomRightNeighbour", this.button));
        DarkUIUtil.repaint(ButtonConstants.getNeighbour("JButton.bottomLeftNeighbour", this.button));
    }

    protected boolean shouldDrawBackground(AbstractButton c) {
        return this.button.isContentAreaFilled();
    }

    protected int getArc(Component c) {
        return ButtonConstants.chooseArcWithBorder(c, this.arc, 0, this.altArc, this.borderSize);
    }

    protected Color getForeground(AbstractButton b) {
        return this.getForegroundColor(b, this.isDefaultButton, b.getModel().isEnabled());
    }

    protected Color getForegroundColor(AbstractButton b, boolean defaultButton, boolean enabled) {
        Color fg = b.getForeground();
        if (defaultButton && !ButtonConstants.isBorderlessVariant(b)) {
            fg = this.defaultForeground;
        }
        if (!enabled) {
            fg = this.inactiveForeground;
        }
        return PropertyUtil.chooseColor(b.getForeground(), fg);
    }

    protected Color getBackgroundColor(AbstractButton b) {
        boolean defaultButton = this.isDefaultButton;
        boolean rollOver = b.isRolloverEnabled() && b.getModel().isRollover();
        boolean clicked = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        return this.getBackgroundColor(b, defaultButton, rollOver, clicked, enabled);
    }

    protected Color getBackgroundColor(AbstractButton b, boolean defaultButton, boolean rollOver, boolean clicked, boolean enabled) {
        if (enabled) {
            if (defaultButton) {
                if (clicked) {
                    return this.defaultClickBackground;
                }
                if (rollOver) {
                    return this.defaultHoverBackground;
                }
                return this.defaultBackground;
            }
            if (clicked) {
                return this.clickBackground;
            }
            if (rollOver) {
                return this.hoverBackground;
            }
            return PropertyUtil.chooseColor(b.getBackground(), this.background);
        }
        return this.inactiveBackground;
    }

    protected Color getBorderlessBackground(AbstractButton c) {
        return this.isArmedBorderless(c) ? PropertyUtil.getColor(c, "JButton.borderless.click", this.borderlessClick) : PropertyUtil.getColor(c, "JButton.borderless.hover", this.borderlessHover);
    }

    public boolean isArmedBorderless(AbstractButton b) {
        return b.getModel().isArmed();
    }

    public Color getBorderlessOutline(AbstractButton c) {
        return this.getBorderlessOutline(this.isArmedBorderless(c));
    }

    public Color getBorderlessOutline(boolean armed) {
        return armed ? this.borderlessOutlineClick : this.borderlessOutlineHover;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        try (CleanupTask clean = this.prepareDelegate(b);){
            Dimension dim = BasicGraphicsUtils.getPreferredButtonSize(this.layoutDelegate, b.getIconTextGap());
            DarkUIUtil.addInsets(dim, b.getMargin());
            if (ButtonConstants.isSquare(b)) {
                int size = Math.max(dim.width, dim.height);
                dim.setSize(size, size);
            }
            Dimension dimension = dim;
            return dimension;
        }
    }

    protected CleanupTask prepareDelegate(AbstractButton b) {
        CleanupTask closeable = this.layoutDelegate.useWithDelegate(b);
        Font f = b.getFont();
        if (ButtonConstants.isDefaultButton(b) && !f.isBold()) {
            this.layoutDelegate.setFont(f.deriveFont(1));
        } else {
            this.layoutDelegate.setFont(f);
        }
        return closeable;
    }

    public void updateMargins(AbstractButton b) {
        Insets margin = b.getMargin();
        if (margin != null && !(margin instanceof UIResource)) {
            return;
        }
        Insets m = this.getMargins(b);
        b.setMargin(new InsetsUIResource(m.top, m.left, m.bottom, m.right));
    }

    protected Insets getMargins(AbstractButton b) {
        if (ButtonConstants.isBorderlessRectangular(b)) {
            return this.borderlessRectangularInsets;
        }
        boolean square = ButtonConstants.isSquare(b);
        return ButtonConstants.isThin(b) ? (square ? this.squareThinInsets : this.thinInsets) : (square ? this.squareInsets : this.insets);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (ButtonConstants.isBorderlessRectangular(c)) {
            return super.contains(c, x, y);
        }
        if (x < 0 || x > c.getWidth() || y < 0 || y > c.getHeight()) {
            return false;
        }
        int bs = c.getBorder() instanceof DarkButtonBorder && !ButtonConstants.isBorderless(c) ? this.borderSize : 0;
        int arc = this.getArc(c);
        hitArea.setRoundRect(bs, bs, c.getWidth() - 2 * bs, c.getHeight() - 2 * bs, arc, arc);
        return hitArea.contains(x, y);
    }

    public boolean getDrawOutline(Component c) {
        return this.drawOutline && ButtonConstants.isBorderless(c);
    }

    public class DarkButtonLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            AbstractButton b = (AbstractButton)parent;
            try (CleanupTask clean = DarkButtonUI.this.prepareDelegate(b);){
                FontMetrics fm = b.getFontMetrics(DarkButtonUI.this.layoutDelegate.getFont());
                DarkButtonUI.this.displayText = this.layout(DarkButtonUI.this.layoutDelegate, b, fm, b.getWidth(), b.getHeight());
            }
        }

        protected String layout(AbstractButtonLayoutDelegate bl, AbstractButton b, FontMetrics fm, int width, int height) {
            this.prepareContentRects(b, width, height);
            int horizontalAlignment = this.getHorizontalAlignment(b);
            int verticalAlignment = this.getHorizontalAlignment(b);
            int verticalTextPosition = this.getVerticalTextPosition(b);
            int horizontalTextPosition = this.getHorizontalTextPosition(b);
            return SwingUtilities.layoutCompoundLabel(bl, fm, bl.getText(), bl.getIcon(), verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, DarkButtonUI.this.viewRect, DarkButtonUI.this.iconRect, DarkButtonUI.this.textRect, bl.getText() == null || ButtonConstants.isIconOnly(b) ? 0 : bl.getIconTextGap());
        }

        protected int getHorizontalTextPosition(AbstractButton b) {
            return b.getHorizontalTextPosition();
        }

        protected int getHorizontalAlignment(AbstractButton b) {
            return b.getHorizontalAlignment();
        }

        protected int getVerticalTextPosition(AbstractButton b) {
            return b.getVerticalTextPosition();
        }

        protected int getVerticalAlignment(AbstractButton b) {
            return b.getVerticalAlignment();
        }

        protected void prepareContentRects(AbstractButton b, int width, int height) {
            Insets i = DarkUIUtil.addInsets(b.getInsets(), b.getMargin());
            AlignmentExt corner = DarkButtonBorder.getCornerFlag(b);
            if (corner != null) {
                Insets insetMask = new Insets(DarkButtonUI.this.borderSize, DarkButtonUI.this.borderSize, DarkButtonUI.this.borderSize, DarkButtonUI.this.borderSize);
                insetMask = corner.maskInsetsInverted(insetMask, 0);
                i.left -= insetMask.left;
                i.right -= insetMask.right;
                i.top -= insetMask.top;
                i.bottom -= insetMask.bottom;
            }
            DarkButtonUI.this.viewRect.setRect(0.0, 0.0, width, height);
            DarkUIUtil.applyInsets(DarkButtonUI.this.viewRect, i);
            DarkButtonUI.this.textRect.height = 0;
            DarkButtonUI.this.textRect.width = 0;
            DarkButtonUI.this.textRect.y = 0;
            DarkButtonUI.this.textRect.x = 0;
            DarkButtonUI.this.iconRect.height = 0;
            DarkButtonUI.this.iconRect.width = 0;
            DarkButtonUI.this.iconRect.y = 0;
            DarkButtonUI.this.iconRect.x = 0;
        }
    }

    protected static class ButtonLayoutDelegate
    extends AbstractButtonLayoutDelegate {
        protected Font font;

        protected ButtonLayoutDelegate() {
        }

        @Override
        public void setFont(Font font) {
            this.font = font;
        }

        @Override
        public Font getFont() {
            return this.font;
        }
    }
}

