/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.color.DarkColorModelHSL;
import com.github.weisj.darklaf.task.ColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Types;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.plaf.ColorUIResource;

public class ForegroundColorGenerationTask
extends ColorAdjustmentTask {
    private static final Logger LOGGER = LogUtil.getLogger(ForegroundColorGenerationTask.class);
    private static final String FOREGROUND_LIST_KEY = "selectionForeground.propertyList";
    private static final String ACCENT_LIST_KEY = "accentForeground.propertyList";
    private static final double DEFAULT_COLOR_ADJUSTED_BG_THRESHOLD = 0.552;
    private static final double DEFAULT_COLOR_ADJUSTED_FG_DIFFERENCE = 0.8;
    private static final double MIN_FOREGROUND_DIFFERENCE = 0.5;

    @Override
    protected void beforeTask(Theme currentTheme, Properties properties) {
        super.beforeTask(currentTheme, properties);
        DEFAULTS.putAll(properties);
    }

    @Override
    protected void runTask(Theme currentTheme, Properties properties) {
        Properties props = currentTheme.loadPropertyFile("accents", true);
        AccentColorRule accentColorRule = currentTheme.getAccentColorRule();
        if (accentColorRule.getAccentColor() != null && currentTheme.supportsCustomAccentColor()) {
            this.adjust(ACCENT_LIST_KEY, props, map -> this.adjustForegroundList((Map<?, ?>)map, properties));
        }
        if (accentColorRule.getSelectionColor() != null && currentTheme.supportsCustomSelectionColor()) {
            this.adjust(FOREGROUND_LIST_KEY, props, map -> this.adjustForegroundList((Map<?, ?>)map, properties));
        }
    }

    private void adjustForegroundList(Map<?, ?> map, Properties properties) {
        map.entrySet().stream().filter(e -> e.getValue() instanceof Color).forEach(e -> {
            Object targets = e.getKey();
            if (targets instanceof String) {
                this.adjustForeground(targets.toString(), (Color)e.getValue(), properties);
            } else if (targets instanceof List) {
                for (Object target : (List)targets) {
                    if (target instanceof String) {
                        this.adjustForeground(target.toString(), (Color)e.getValue(), properties);
                        continue;
                    }
                    LOGGER.warning("Invalid target " + target);
                }
            } else {
                LOGGER.warning("Invalid target declaration " + targets);
            }
        });
    }

    private void adjustForeground(String fgKey, Color bg, Properties properties) {
        Color suggestion = Types.safeCast(properties.get(fgKey), Color.class);
        ColorUIResource c = ForegroundColorGenerationTask.makeAdjustedForeground(suggestion, bg, Bias.BACKGROUND, 0.8, 0.552);
        properties.put(fgKey, c);
    }

    public static ColorUIResource makeForeground(Color bg) {
        return ForegroundColorGenerationTask.makeForeground(bg, 0.5);
    }

    public static ColorUIResource makeForeground(Color bg, double minimumBrightnessDifference) {
        return ForegroundColorGenerationTask.makeAdjustedForeground(null, bg, Bias.BACKGROUND, minimumBrightnessDifference);
    }

    public static ColorUIResource makeAdjustedForeground(Color fg, Color bg) {
        return ForegroundColorGenerationTask.makeAdjustedForeground(fg, bg, 0.5);
    }

    public static ColorUIResource makeAdjustedForeground(Color fg, Color bg, double minimumBrightnessDifference) {
        return ForegroundColorGenerationTask.makeAdjustedForeground(fg, bg, Bias.BACKGROUND, minimumBrightnessDifference);
    }

    public static ColorUIResource makeAdjustedForeground(Color fgSuggestion, Color bg, Bias bias, double minimumBrightnessDifference) {
        return ForegroundColorGenerationTask.makeAdjustedForeground(fgSuggestion, bg, bias, minimumBrightnessDifference, 0.552);
    }

    public static ColorUIResource makeAdjustedForeground(Color fgSuggestion, Color bg, Bias bias, double minimumBrightnessDifference, double backgroundBiasThreshold) {
        Bias b;
        Color fg = fgSuggestion;
        if (fg == null) {
            double[] hsbBG = DarkColorModelHSB.RGBtoHSBValues(bg.getRed(), bg.getGreen(), bg.getBlue());
            fg = DarkColorModelHSB.getColorFromHSBValues(hsbBG[0], 0.0, 1.0 - hsbBG[2]);
        }
        double[] hslFG = DarkColorModelHSL.RGBtoHSLValues(fg.getRed(), fg.getGreen(), fg.getBlue());
        double[] hslBG = DarkColorModelHSL.RGBtoHSLValues(bg.getRed(), bg.getGreen(), bg.getBlue());
        double bgBrightness = hslBG[2];
        double fgBrightness = hslFG[2];
        Bias bias2 = b = bias != null ? bias : Bias.BACKGROUND;
        if (b == Bias.BACKGROUND) {
            double bgBright = ColorUtil.getLuminance(bg);
            double threshold = backgroundBiasThreshold < 0.0 ? 0.5 : backgroundBiasThreshold;
            b = bgBright <= threshold ? Bias.WHITE : Bias.BLACK;
        }
        double bright1 = fgBrightness > bgBrightness && fgBrightness - bgBrightness >= minimumBrightnessDifference ? hslFG[2] : Math.min(bgBrightness + minimumBrightnessDifference, 1.0);
        double bright2 = fgBrightness < bgBrightness && bgBrightness - fgBrightness >= minimumBrightnessDifference ? hslFG[2] : Math.max(bgBrightness - minimumBrightnessDifference, 0.0);
        double brightness = b == Bias.WHITE ? bright1 : bright2;
        return new DarkColorUIResource(DarkColorModelHSL.getColorFromHSLValues(hslFG[0], hslFG[1], brightness));
    }

    public static enum Bias {
        BACKGROUND,
        WHITE,
        BLACK;

    }
}

