/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.layout.LayoutHelper;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.settings.ThemeSettings;
import com.github.weisj.darklaf.settings.ThemeSettingsUI;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class ThemeSettingsPanel
extends JPanel {
    private final ThemeSettingsUI settingsUI = new ThemeSettingsUI();

    public ThemeSettingsPanel() {
        this(GroupLayout.Alignment.TRAILING, new Insets(LayoutHelper.getDefaultSpacing(), 0, 0, 0));
    }

    public ThemeSettingsPanel(GroupLayout.Alignment alignment, Insets insets) {
        this.setLayout(new BorderLayout());
        this.setBorder(LayoutHelper.createEmptyContainerBorder());
        this.add((Component)this.createGeneralSettings(alignment, insets), "Center");
        this.add(this.createMonitorSettings(alignment, insets), "South");
    }

    public void loadConfiguration(SettingsConfiguration configuration) {
        this.settingsUI.loadConfiguration(configuration);
    }

    public void setThemeComboBoxRenderer(ListCellRenderer<Theme> renderer) {
        this.settingsUI.getThemeComboBox().setRenderer(renderer != null ? renderer : LafManager.getThemeListCellRenderer());
    }

    public void addChangeListener(ChangeListener listener) {
        this.settingsUI.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.settingsUI.removeChangeListener(listener);
    }

    protected void updateConfiguration() {
        ThemeSettings.getInstance().setConfiguration(this.getSettingsConfiguration());
    }

    public SettingsConfiguration getSettingsConfiguration() {
        return this.settingsUI.getSettingsConfiguration();
    }

    private static JLabel createDynamicLabel(String key) {
        return DynamicUI.withDynamic(new JLabel(), c -> c.setText(UIManager.getString((Object)key, c.getLocale())));
    }

    private JComponent createGeneralSettings(GroupLayout.Alignment alignment, Insets insets) {
        Locale l = this.getLocale();
        JLabel themeLabel = ThemeSettingsPanel.createDynamicLabel("label_theme");
        JComboBox<Theme> themeComboBox = this.settingsUI.getThemeComboBox();
        themeLabel.setLabelFor(themeComboBox);
        JPanel themeBox = new JPanel(new FlowLayout(0));
        themeBox.setAlignmentX(0.0f);
        themeBox.add(themeLabel);
        themeBox.add(themeComboBox);
        this.add(themeBox);
        Box selectionBox = Box.createHorizontalBox();
        JLabel selectionColorLabel = ThemeSettingsPanel.createDynamicLabel("label_selection_color");
        selectionColorLabel.setLabelFor(selectionBox);
        this.settingsUI.getSelectionChooser().getRadioButtons().forEach(selectionBox::add);
        Box accentBox = Box.createHorizontalBox();
        JLabel accentColorLabel = ThemeSettingsPanel.createDynamicLabel("label_accent_color");
        accentColorLabel.setLabelFor(accentBox);
        this.settingsUI.getAccentChooser().getRadioButtons().forEach(accentBox::add);
        JSlider fontSlider = this.settingsUI.getFontSlider();
        JLabel fontSizeLabel = ThemeSettingsPanel.createDynamicLabel("label_font_size");
        fontSizeLabel.setLabelFor(fontSlider);
        JPanel panel = DynamicUI.withDynamic(new JPanel(new BorderLayout()), c -> c.setBorder(BorderFactory.createTitledBorder(UIManager.getString((Object)"title_general", this.getLocale()))));
        JComponent c2 = LayoutHelper.createTwoColumnPanel(new JLabel[]{themeLabel, accentColorLabel, selectionColorLabel, fontSizeLabel}, new JComponent[]{themeComboBox, accentBox, selectionBox, fontSlider}, alignment, GroupLayout.Alignment.LEADING);
        c2.setBorder(LayoutHelper.createEmptyBorder(insets));
        panel.add(c2);
        return panel;
    }

    private Component createMonitorSettings(GroupLayout.Alignment alignment, Insets insets) {
        TristateCheckBox enabledSystemPreferences = this.settingsUI.getSystemPreferencesTristateCheckBox();
        Insets ins = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        if (alignment == GroupLayout.Alignment.LEADING) {
            Insets padding = ((VisualPaddingProvider)((Object)enabledSystemPreferences.getBorder())).getVisualPaddings(enabledSystemPreferences);
            ins = DarkUIUtil.addInsets(ins, DarkUIUtil.invert(padding));
        }
        JPanel panel = DynamicUI.withDynamic(new JPanel(new BorderLayout()), c -> c.setBorder(BorderFactory.createTitledBorder(UIManager.getString((Object)"title_monitoring", this.getLocale()))));
        JComponent c2 = LayoutHelper.createTwoColumnPanel(new JComponent[]{enabledSystemPreferences, this.settingsUI.getThemeFollowsSystemCheckBox(), this.settingsUI.getAccentColorFollowsSystemCheckBox()}, new JComponent[]{new JLabel(), this.settingsUI.getFontSizeFollowsSystemCheckBox(), this.settingsUI.getSelectionColorFollowsSystemCheckBox()}, GroupLayout.Alignment.LEADING, GroupLayout.Alignment.LEADING);
        c2.setBorder(LayoutHelper.createEmptyBorder(ins));
        panel.add(c2);
        return panel;
    }
}

