/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.macos.JNIThemeInfoMacOS;
import com.github.weisj.darklaf.platform.macos.MacOSLibrary;
import com.github.weisj.darklaf.platform.macos.MacOSPreferenceMonitor;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.ColorToneRule;
import com.github.weisj.darklaf.theme.info.ContrastRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemePreferenceProvider;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Color;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

public class MacOSThemePreferenceProvider
implements ThemePreferenceProvider {
    private final PreferredThemeStyle fallbackStyle = new PreferredThemeStyle(ContrastRule.STANDARD, ColorToneRule.LIGHT);
    private final MacOSPreferenceMonitor monitor = new MacOSPreferenceMonitor(this);
    private Consumer<PreferredThemeStyle> callback;

    @Override
    public PreferredThemeStyle getPreference() {
        if (!MacOSLibrary.get().isLoaded()) {
            return this.fallbackStyle;
        }
        boolean darkMode = JNIThemeInfoMacOS.isDarkThemeEnabled();
        boolean highContrast = JNIThemeInfoMacOS.isHighContrastEnabled();
        Color accentColor = JNIThemeInfoMacOS.getAccentColor();
        Color selectionColor = JNIThemeInfoMacOS.getSelectionColor();
        return this.create(highContrast, darkMode, accentColor, selectionColor);
    }

    private PreferredThemeStyle create(boolean highContrast, boolean darkMode, Color accentColor, Color selectionColor) {
        ContrastRule contrastRule = highContrast ? ContrastRule.HIGH_CONTRAST : ContrastRule.STANDARD;
        ColorToneRule toneRule = darkMode ? ColorToneRule.DARK : ColorToneRule.LIGHT;
        AccentColorRule accentColorRule = AccentColorRule.fromColor(accentColor, selectionColor);
        return new PreferredThemeStyle(contrastRule, toneRule, accentColorRule);
    }

    void reportPreferenceChange(boolean dark, boolean highContrast, Color accentColor, Color selectionColor) {
        if (this.callback != null) {
            PreferredThemeStyle style = this.create(dark, highContrast, accentColor, selectionColor);
            this.callback.accept(style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReporting(boolean reporting) {
        if (reporting && !MacOSLibrary.get().isLoaded()) {
            MacOSLibrary.get().updateLibrary();
        }
        MacOSPreferenceMonitor macOSPreferenceMonitor = this.monitor;
        synchronized (macOSPreferenceMonitor) {
            this.monitor.setRunning(reporting);
        }
    }

    @Override
    public boolean isReporting() {
        return this.monitor.isRunning();
    }

    @Override
    public void initialize() {
        MacOSLibrary.get().updateLibrary();
        if (MacOSLibrary.get().isLoaded()) {
            JNIThemeInfoMacOS.patchAppBundle(!SystemInfo.isJavaVersionAtLeast("12"));
            SwingUtilities.invokeLater(() -> {});
            JNIThemeInfoMacOS.unpatchAppBundle();
        }
    }

    @Override
    public void setCallback(Consumer<PreferredThemeStyle> callback) {
        this.callback = callback;
    }

    @Override
    public boolean canReport() {
        return true;
    }

    @Override
    public boolean supportsNativeAccentColor() {
        return SystemInfo.isMacOSMojave && MacOSLibrary.get().isLoaded();
    }

    @Override
    public boolean supportsNativeSelectionColor() {
        return SystemInfo.isMacOSMojave && MacOSLibrary.get().isLoaded();
    }

    @Override
    public boolean supportsNativeTheme() {
        return MacOSLibrary.get().isLoaded();
    }
}

