/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.parser;

import com.github.weisj.darklaf.parser.Delimiters;
import com.github.weisj.darklaf.parser.ParseResult;
import com.github.weisj.darklaf.parser.Parser;
import com.github.weisj.darklaf.parser.ParserContext;
import com.github.weisj.darklaf.parser.PropertyParser;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class ParserUtil
implements Delimiters {
    private static final char EMPTY_CHAR = '\u0000';
    private static final Logger LOGGER = LogUtil.getLogger(PropertyParser.class);

    ParserUtil() {
    }

    static ParseResult error(ParseResult parseResult, String message) {
        LOGGER.severe("Error while parsing " + parseResult + ". " + message);
        parseResult.finished = true;
        parseResult.result = null;
        return parseResult;
    }

    static void warning(String message) {
        LOGGER.warning(message);
    }

    static ParseResult apply(PropertyParser parser, ParseResult p, ParserContext c) {
        return parser != null ? parser.parse(p, c) : p;
    }

    static boolean startsWith(ParseResult parseResult, String prefix) {
        return parseResult.value.startsWith(prefix);
    }

    static boolean startsWith(ParseResult parseResult, char prefix) {
        return parseResult.value.length() > 0 && parseResult.value.charAt(0) == prefix;
    }

    static boolean stripPrefixFromKey(ParseResult parseResult, String prefix) {
        if (parseResult.key.startsWith(prefix)) {
            parseResult.key = parseResult.key.substring(prefix.length());
            return true;
        }
        return false;
    }

    static boolean stripPrefixFromValue(ParseResult parseResult, String prefix) {
        if (ParserUtil.startsWith(parseResult, prefix)) {
            parseResult.value = parseResult.value.substring(prefix.length());
            return true;
        }
        return false;
    }

    static void replaceIfNull(ParseResult parseResult, String key, Map<Object, Object> map) {
        if (parseResult.finished) {
            return;
        }
        Object obj = map.get(key);
        while (obj instanceof ParseResult) {
            obj = ((ParseResult)obj).result;
        }
        ParserUtil.setNonNull(parseResult, obj);
    }

    static ParseResult setNonNull(ParseResult parseResult, Object result) {
        if (result != null) {
            parseResult.result = result;
            parseResult.finished = true;
        }
        return parseResult;
    }

    static <T> Optional<T> parseBetween(char start, char end, Class<T> type, ParseResult parseResult, ParserContext context) {
        return ParserUtil.parseBetween(start, end, Parser::parse, type, parseResult, context);
    }

    static <T> Optional<T> parseBetween(char start, char end, PropertyParser parser, Class<T> type, ParseResult parseResult, ParserContext context) {
        List<T> parsed = ParserUtil.parseDelimited(start, end, '\u0000', parser, type, parseResult, context);
        return parsed.stream().findFirst();
    }

    static <T> List<T> parseDelimited(char delimiter, PropertyParser parser, Class<T> type, ParseResult parseResult, ParserContext context) {
        return ParserUtil.parseDelimited('\u0000', '\u0000', delimiter, parser, type, parseResult, context);
    }

    static <T> List<T> parseDelimited(char delimiter, Class<T> type, ParseResult parseResult, ParserContext context) {
        return ParserUtil.parseDelimited(delimiter, Parser::parse, type, parseResult, context);
    }

    static <T> List<T> parseDelimited(char start, char end, char delimiter, Class<T> type, ParseResult parseResult, ParserContext context) {
        return ParserUtil.parseDelimited(start, end, delimiter, Parser::parse, type, parseResult, context);
    }

    static <T> List<T> parseDelimited(char start, char end, char delimiter, PropertyParser parser, Class<T> type, ParseResult parseResult, ParserContext context) {
        return ParserUtil.parseDelimited(start, end, delimiter, true, parser, type, parseResult, context);
    }

    static <T> List<T> parseDelimited(char start, char end, char delimiter, boolean forward, PropertyParser parser, Class<T> type, ParseResult parseResult, ParserContext context) {
        List<String> values;
        if (forward) {
            if (start != '\u0000') {
                if (parseResult.value.charAt(0) == start) {
                    parseResult.value = parseResult.value.substring(1);
                } else {
                    LOGGER.warning("Expected '" + start + "' while parsing " + parseResult.value);
                }
            }
        } else if (end != '\u0000') {
            if (parseResult.value.charAt(parseResult.value.length() - 1) == end) {
                parseResult.value = parseResult.value.substring(0, parseResult.value.length() - 1);
            } else {
                LOGGER.warning("Expected '" + start + "' while parsing " + parseResult.value);
            }
        }
        if ((values = ParserUtil.delimitedSplit(delimiter, forward ? end : start, parseResult, forward)).size() == 0) {
            return Collections.emptyList();
        }
        List parsed = values.stream().map(v -> Parser.createParseResult(parseResult.key, v)).map(p -> parser.parse((ParseResult)p, context)).map(p -> {
            Object casted = Types.safeCast(p.result, type);
            if (casted == null) {
                LOGGER.warning("Value " + p.result + " is not of type " + type + ". Encountered while parsing '" + p + "' for '" + parseResult + "'");
            }
            return casted;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!forward) {
            Collections.reverse(parsed);
        }
        return parsed;
    }

    static List<String> delimitedSplit(char delimiter, char closingDelimiter, ParseResult parseResult, boolean forward) {
        int i;
        int lastPos;
        String value = parseResult.value;
        int openDelimiters = 0;
        ArrayList<String> values = new ArrayList<String>();
        boolean done = false;
        int step = forward ? 1 : -1;
        int end = forward ? value.length() : -1;
        int n = lastPos = forward ? 0 : value.length();
        for (i = forward ? 0 : value.length() - 1; i != end; i += step) {
            char c = value.charAt(i);
            if (openDelimiters == 0) {
                if (closingDelimiter != '\u0000' && closingDelimiter == c) {
                    done = true;
                    break;
                }
                if (delimiter == c) {
                    if (forward) {
                        values.add(value.substring(lastPos, i));
                        lastPos = i + 1;
                    } else {
                        values.add(value.substring(i + 1, lastPos));
                        lastPos = i;
                    }
                }
            }
            if (ParserUtil.isOpenDelimiter(c)) {
                ++openDelimiters;
            }
            if (!ParserUtil.isClosingDelimiter(c)) continue;
            --openDelimiters;
        }
        if (!done && lastPos != end) {
            if (forward) {
                values.add(value.substring(lastPos));
            } else {
                values.add(value.substring(0, lastPos));
            }
            parseResult.value = "";
        } else if (forward) {
            values.add(value.substring(lastPos, i));
            int endIndex = closingDelimiter != '\u0000' ? i + 1 : i;
            parseResult.value = parseResult.value.substring(endIndex);
        } else {
            values.add(value.substring(i + 1, lastPos));
            parseResult.value = parseResult.value.substring(0, i);
        }
        return values;
    }

    static Object createObject(String value) {
        try {
            return Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isOpenDelimiter(char c) {
        return c == '[' || c == '{' || c == '(';
    }

    private static boolean isClosingDelimiter(char c) {
        return c == ']' || c == '}' || c == ')';
    }
}

