/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.listener;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.event.ThemeChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemeChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class UIUpdater
implements ThemeChangeListener {
    private static final String KEY_UPDATER = "JComponent.uiUpdaterLister";
    private final WeakReference<JComponent> component;

    public static void registerComponent(JComponent component) {
        if (component == null) {
            return;
        }
        UIUpdater.removeComponent(component);
        UIUpdater updater = new UIUpdater(component);
        component.putClientProperty(KEY_UPDATER, updater);
        LafManager.addThemeChangeListener(new UIUpdater(component));
    }

    public static void removeComponent(JComponent component) {
        Object updater = component.getClientProperty(KEY_UPDATER);
        if (updater instanceof UIUpdater) {
            UIUpdater.removeComponent(component, (UIUpdater)updater);
        }
    }

    private static void removeComponent(JComponent component, UIUpdater updater) {
        if (component != null) {
            component.putClientProperty(KEY_UPDATER, null);
        }
        LafManager.removeThemeChangeListener(updater);
    }

    public UIUpdater(JComponent component) {
        this.component = new WeakReference<JComponent>(component);
    }

    @Override
    public void themeChanged(ThemeChangeEvent e) {
    }

    @Override
    public void themeInstalled(ThemeChangeEvent e) {
        JComponent comp = (JComponent)this.component.get();
        if (comp != null) {
            SwingUtilities.updateComponentTreeUI(comp);
        } else {
            UIUpdater.removeComponent(null, this);
        }
    }
}

