/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.parser.ParseResult;
import com.github.weisj.darklaf.parser.Parser;
import com.github.weisj.darklaf.parser.ParserContext;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.Types;
import com.kitfox.svg.Defs;
import com.kitfox.svg.LinearGradient;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.Stop;
import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class IconColorMapper {
    private static final String INLINE_VALUE_PREFIX = "#";
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final Color FALLBACK_COLOR = Color.RED;

    public static void patchColors(SVGIcon svgIcon) {
        IconColorMapper.patchColors(svgIcon, UIManager.getDefaults());
    }

    public static void patchColors(SVGIcon svgIcon, Map<Object, Object> contextDefaults) {
        IconColorMapper.patchColors(svgIcon, contextDefaults, null);
    }

    public static void patchColors(SVGIcon svgIcon, Map<Object, Object> defaults, Map<Object, Object> contextDefaults) {
        SVGUniverse universe = svgIcon.getSvgUniverse();
        SVGDiagram diagram = universe.getDiagram(svgIcon.getSvgURI());
        LOGGER.finer(() -> "Patching colors of icon " + svgIcon.getSvgURI());
        try {
            IconColorMapper.loadColors(diagram, defaults, contextDefaults);
        }
        catch (SVGElementException e) {
            LOGGER.log(Level.SEVERE, "Failed patching colors. " + e.getMessage(), e.getStackTrace());
        }
    }

    private static void loadColors(SVGDiagram diagram, Map<Object, Object> defaults, Map<Object, Object> contextDefaults) throws SVGElementException {
        SVGRoot root = diagram.getRoot();
        SVGElement defs = diagram.getElement("colors");
        if (defs == null) {
            LOGGER.info(() -> {
                String uri = diagram.getXMLBase().toASCIIString();
                String name = uri.substring(Math.min(uri.lastIndexOf(47) + 1, uri.length() - 1));
                return "Themed icon '" + name + "' has no color definitions. Consider loading it as a standard icon or add missing definitions";
            });
            return;
        }
        List<SVGElement> children = defs.getChildren(null);
        root.removeChild(defs);
        Defs themedDefs = new Defs();
        themedDefs.addAttribute("id", 1, "colors");
        root.loaderAddChild(null, themedDefs);
        for (SVGElement child : children) {
            float opacity;
            if (!(child instanceof LinearGradient)) continue;
            LinearGradient grad = (LinearGradient)child;
            String id = grad.getId();
            StyleAttribute colorFallbacks = IconColorMapper.getAttribute("fallback", grad);
            StyleAttribute opacityFallbacks = IconColorMapper.getAttribute("opacity-fallback", grad);
            String opacityKey = IconColorMapper.getOpacityKey(grad);
            float opacity1 = opacity = IconColorMapper.getOpacity(opacityKey, IconColorMapper.getFallbacks(opacityFallbacks), defaults, contextDefaults);
            float opacity2 = opacity;
            if (opacity < 0.0f) {
                SVGElement elem;
                opacity = 1.0f;
                int childCount = grad.getNumChildren();
                if (childCount > 0 && (elem = grad.getChild(0)) instanceof Stop) {
                    opacity1 = IconColorMapper.getStopOpacity((Stop)elem);
                }
                if (childCount > 1 && (elem = grad.getChild(1)) instanceof Stop) {
                    opacity2 = IconColorMapper.getStopOpacity((Stop)elem);
                }
                if (opacity1 < 0.0f) {
                    opacity1 = opacity;
                }
                if (opacity2 < 0.0f) {
                    opacity2 = opacity;
                }
            }
            Color c = IconColorMapper.resolveColor(id, IconColorMapper.getFallbacks(colorFallbacks), FALLBACK_COLOR, defaults, contextDefaults);
            Pair<LinearGradient, Runnable> result = IconColorMapper.createColor(c, id, opacityKey, new StyleAttribute[]{colorFallbacks, opacityFallbacks}, opacity1, opacity2);
            LinearGradient gradient = result.getFirst();
            Runnable finalizer = result.getSecond();
            themedDefs.loaderAddChild(null, gradient);
            finalizer.run();
        }
    }

    public static float getOpacity(LinearGradient gradient, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        String opacityKey = IconColorMapper.getOpacityKey(gradient);
        return IconColorMapper.getOpacity(opacityKey, null, propertyMap, contextDefaults);
    }

    public static Color getColor(LinearGradient gradient, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        String id = gradient.getId();
        StyleAttribute fallbacks = IconColorMapper.getAttribute("fallback", gradient);
        return IconColorMapper.resolveColor(id, IconColorMapper.getFallbacks(fallbacks), FALLBACK_COLOR, propertyMap, contextDefaults);
    }

    private static Color resolveColor(String key, String[] fallbacks, Color fallbackColor, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        Color color = IconColorMapper.get(propertyMap, contextDefaults, key, fallbacks, Color.class);
        if (color == null) {
            color = fallbackColor;
            LOGGER.warning("Could not load color with id '" + key + "' fallbacks" + Arrays.toString(fallbacks) + ". Using color '" + fallbackColor + "' instead.");
        }
        return color;
    }

    private static StyleAttribute getAttribute(String key, SVGElement child) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName(key);
        try {
            child.getStyle(attribute);
        }
        catch (SVGException e) {
            return null;
        }
        return attribute;
    }

    private static float getStopOpacity(Stop stop) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName("stop-opacity");
        try {
            stop.getStyle(attribute);
        }
        catch (SVGException e) {
            return -1.0f;
        }
        return !attribute.getStringValue().isEmpty() ? attribute.getFloatValue() : -1.0f;
    }

    private static String[] getFallbacks(StyleAttribute fallbacks) {
        if (fallbacks == null) {
            return new String[0];
        }
        return fallbacks.getStringList();
    }

    private static float getOpacity(String key, String[] fallbacks, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        if (!(key != null && !key.isEmpty() || fallbacks != null && fallbacks.length != 0)) {
            return -1.0f;
        }
        Number obj = IconColorMapper.get(propertyMap, contextDefaults, key, fallbacks, Number.class);
        if (obj instanceof Integer) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Long) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Float) {
            return obj.floatValue();
        }
        if (obj instanceof Double) {
            return obj.floatValue();
        }
        LOGGER.warning(obj + " is an invalid opacity value. Key = '" + key + "'");
        return -1.0f;
    }

    private static String getOpacityKey(LinearGradient child) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName("opacity");
        try {
            child.getStyle(attribute);
        }
        catch (SVGException e) {
            e.printStackTrace();
            return null;
        }
        return attribute.getStringValue();
    }

    private static Pair<LinearGradient, Runnable> createColor(Color c, String name, String opacityKey, StyleAttribute[] extraAttributes, float opacity1, float opacity2) throws SVGElementException {
        LinearGradient grad = new LinearGradient();
        grad.addAttribute("id", 1, name);
        if (opacityKey != null && !opacityKey.isEmpty()) {
            grad.addAttribute("opacity", 1, opacityKey);
        }
        if (extraAttributes != null) {
            for (StyleAttribute attribute : extraAttributes) {
                if (attribute == null || attribute.getStringValue().isEmpty()) continue;
                grad.addAttribute(attribute.getName(), 1, attribute.getStringValue());
            }
        }
        return new Pair<LinearGradient, Runnable>(grad, () -> {
            Stop stop1 = new Stop();
            Stop stop2 = new Stop();
            String color = IconColorMapper.toHexString(c);
            try {
                stop1.addAttribute("stop-color", 1, color);
                stop1.addAttribute("offset", 1, "0");
                stop2.addAttribute("stop-color", 1, color);
                stop2.addAttribute("offset", 1, "1");
                if (opacity1 != 1.0f) {
                    stop1.addAttribute("stop-opacity", 1, String.valueOf(opacity1));
                }
                if (opacity2 != 1.0f) {
                    stop2.addAttribute("stop-opacity", 1, String.valueOf(opacity2));
                }
                grad.loaderAddChild(null, stop1);
                grad.loaderAddChild(null, stop2);
            }
            catch (SVGException e) {
                e.printStackTrace();
            }
        });
    }

    public static Map<Object, Object> getProperties(SVGIcon svgIcon) {
        SVGUniverse universe = svgIcon.getSvgUniverse();
        SVGDiagram diagram = universe.getDiagram(svgIcon.getSvgURI());
        SVGElement defs = diagram.getElement("colors");
        HashMap<Object, Object> values = new HashMap<Object, Object>();
        if (defs != null) {
            List<SVGElement> children = defs.getChildren(null);
            for (SVGElement child : children) {
                if (!(child instanceof LinearGradient)) continue;
                LinearGradient grad = (LinearGradient)child;
                String colorKey = grad.getId();
                String opacityKey = IconColorMapper.getOpacityKey(grad);
                SVGElement c = grad.getChild(0);
                if (!(c instanceof Stop)) continue;
                Stop stop = (Stop)c;
                StyleAttribute colorAttr = IconColorMapper.getAttribute("stop-color", stop);
                Color color = colorAttr != null ? colorAttr.getColorValue() : null;
                values.put(colorKey, color != null ? color : Color.BLACK);
                if (opacityKey == null || opacityKey.isEmpty()) continue;
                StyleAttribute opacityAttr = IconColorMapper.getAttribute("stop-opacity", stop);
                int opacity = opacityAttr != null ? (int)(100.0f * opacityAttr.getFloatValue()) : 100;
                values.put(opacityKey, opacity);
            }
        }
        return values;
    }

    public static <T> Pair<Object, T> getEntry(Map<Object, Object> map, Map<Object, Object> contextDefaults, Object key, Object[] fallbacks, Class<T> type) {
        Object obj = null;
        String refPrefix = PropertyLoader.getReferencePrefix();
        HashSet<Object> seen = new HashSet<Object>();
        Object currentKey = key;
        int max = fallbacks != null ? fallbacks.length : 0;
        for (int i = -1; i < max; ++i) {
            currentKey = i < 0 ? key : fallbacks[i];
            int retryCount = 5;
            if (i >= 0 && currentKey instanceof String && ((String)currentKey).startsWith(INLINE_VALUE_PREFIX)) {
                ParseResult p = Parser.parse(Parser.createParseResult(Objects.toString(key), ((String)currentKey).substring(INLINE_VALUE_PREFIX.length())), new ParserContext(map, contextDefaults, IconLoader.get()));
                obj = Types.safeCast(p.result, type);
            }
            do {
                if (obj == null) {
                    obj = map.get(currentKey);
                }
                if (contextDefaults != null && (obj == null || seen.contains(obj))) {
                    obj = contextDefaults.get(currentKey);
                }
                seen.add(obj);
                if (!(obj instanceof String) || !obj.toString().startsWith(refPrefix)) continue;
                currentKey = obj.toString().substring(refPrefix.length());
                obj = null;
            } while (!type.isInstance(obj) && --retryCount > 0);
            if (retryCount > 0) break;
        }
        return new Pair<Object, T>(currentKey, type.cast(obj));
    }

    public static <T> T get(Map<Object, Object> map, Map<Object, Object> contextDefaults, Object key, Object[] fallbacks, Class<T> type) {
        return IconColorMapper.getEntry(map, contextDefaults, key, fallbacks, type).getSecond();
    }

    private static String toHexString(Color color) {
        return INLINE_VALUE_PREFIX + ColorUtil.toHex(color);
    }
}

