/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.util.Disposable;
import com.github.weisj.darklaf.util.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;

public class DropShadowBorder
implements Border,
Serializable {
    private static final Map<Integer, BufferedImage[]> CACHE = new HashMap<Integer, BufferedImage[]>();
    private Color shadowColor;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;
    private boolean showTopShadow;
    private boolean showLeftShadow;
    private boolean showBottomShadow;
    private boolean showRightShadow;

    public DropShadowBorder() {
        this(Color.BLACK, 5);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize) {
        this(shadowColor, shadowSize, 0.5f, 12, false, true, true, true);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize, float shadowOpacity, int cornerSize, boolean showTopShadow, boolean showLeftShadow, boolean showBottomShadow, boolean showRightShadow) {
        this.setShadowColor(shadowColor);
        this.setShadowSize(shadowSize);
        this.setShadowOpacity(shadowOpacity);
        this.setCornerSize(cornerSize);
        this.setShowTopShadow(showTopShadow);
        this.setShowLeftShadow(showLeftShadow);
        this.setShowBottomShadow(showBottomShadow);
        this.setShowRightShadow(showRightShadow);
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        BufferedImage[] images = this.getImages();
        Graphics2D g2 = (Graphics2D)graphics.create();
        try (Disposable d = g2::dispose;){
            int shadowOffset = 2;
            Point topLeftShadowPoint = null;
            if (this.showLeftShadow || this.showTopShadow) {
                topLeftShadowPoint = new Point();
                if (this.showLeftShadow && !this.showTopShadow) {
                    topLeftShadowPoint.setLocation(x, y + shadowOffset);
                } else if (this.showLeftShadow) {
                    topLeftShadowPoint.setLocation(x, y);
                } else {
                    topLeftShadowPoint.setLocation(x + this.shadowSize, y);
                }
            }
            Point bottomLeftShadowPoint = null;
            if (this.showLeftShadow || this.showBottomShadow) {
                bottomLeftShadowPoint = new Point();
                if (this.showLeftShadow && !this.showBottomShadow) {
                    bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize - this.shadowSize);
                } else if (this.showLeftShadow) {
                    bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize);
                } else {
                    bottomLeftShadowPoint.setLocation(x + this.shadowSize, y + height - this.shadowSize);
                }
            }
            Point bottomRightShadowPoint = null;
            if (this.showRightShadow || this.showBottomShadow) {
                bottomRightShadowPoint = new Point();
                if (this.showRightShadow && !this.showBottomShadow) {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize - this.shadowSize);
                } else if (this.showRightShadow) {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize);
                } else {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y + height - this.shadowSize);
                }
            }
            Point topRightShadowPoint = null;
            if (this.showRightShadow || this.showTopShadow) {
                topRightShadowPoint = new Point();
                if (this.showRightShadow && !this.showTopShadow) {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize, y + shadowOffset);
                } else if (this.showRightShadow) {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize, y);
                } else {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y);
                }
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (this.showLeftShadow) {
                assert (topLeftShadowPoint != null && bottomLeftShadowPoint != null);
                this.drawImage(g2, images[Position.LEFT.ordinal()], x, topLeftShadowPoint.y + this.shadowSize, this.shadowSize, bottomLeftShadowPoint.y - topLeftShadowPoint.y - this.shadowSize, c);
            }
            if (this.showBottomShadow) {
                assert (bottomLeftShadowPoint != null && bottomRightShadowPoint != null);
                this.drawImage(g2, images[Position.BOTTOM.ordinal()], bottomLeftShadowPoint.x + this.shadowSize, y + height - this.shadowSize, bottomRightShadowPoint.x - bottomLeftShadowPoint.x - this.shadowSize, this.shadowSize, c);
            }
            if (this.showRightShadow) {
                assert (topRightShadowPoint != null && bottomRightShadowPoint != null);
                this.drawImage(g2, images[Position.RIGHT.ordinal()], x + width - this.shadowSize, topRightShadowPoint.y + this.shadowSize, this.shadowSize, bottomRightShadowPoint.y - topRightShadowPoint.y - this.shadowSize, c);
            }
            if (this.showTopShadow) {
                assert (topLeftShadowPoint != null && topRightShadowPoint != null);
                this.drawImage(g2, images[Position.TOP.ordinal()], topLeftShadowPoint.x + this.shadowSize, y, topRightShadowPoint.x - topLeftShadowPoint.x - this.shadowSize, this.shadowSize, c);
            }
            if (this.showLeftShadow || this.showTopShadow) {
                this.drawImage(g2, images[Position.TOP_LEFT.ordinal()], topLeftShadowPoint, c);
            }
            if (this.showLeftShadow || this.showBottomShadow) {
                this.drawImage(g2, images[Position.BOTTOM_LEFT.ordinal()], bottomLeftShadowPoint, c);
            }
            if (this.showRightShadow || this.showBottomShadow) {
                this.drawImage(g2, images[Position.BOTTOM_RIGHT.ordinal()], bottomRightShadowPoint, c);
            }
            if (this.showRightShadow || this.showTopShadow) {
                this.drawImage(g2, images[Position.TOP_RIGHT.ordinal()], topRightShadowPoint, c);
            }
        }
    }

    protected void drawImage(Graphics g, Image image, Point p, ImageObserver observer) {
        if (p == null) {
            return;
        }
        g.drawImage(image, p.x, p.y, observer);
    }

    protected void drawImage(Graphics g, Image image, int x, int y, int w, int h, ImageObserver observer) {
        g.drawImage(image, x, y, w, h, observer);
    }

    private BufferedImage[] getImages() {
        BufferedImage[] images = CACHE.get(DropShadowBorder.getBorderHash(this.shadowSize, this.shadowOpacity, this.shadowColor));
        if (images == null) {
            images = new BufferedImage[Position.count()];
            int rectWidth = this.cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, this.cornerSize, this.cornerSize);
            int imageWidth = rectWidth + this.shadowSize * 2;
            BufferedImage image = ImageUtil.createCompatibleTranslucentImage(imageWidth, imageWidth);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            try (Disposable d = buffer::dispose;){
                buffer.setPaint(new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(this.shadowOpacity * 255.0f)));
                buffer.translate(this.shadowSize, this.shadowSize);
                buffer.fill(rect);
            }
            float blurry = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] blurKernel = new float[this.shadowSize * this.shadowSize];
            Arrays.fill(blurKernel, blurry);
            ConvolveOp blur = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, blurKernel));
            BufferedImage targetImage = ImageUtil.createCompatibleTranslucentImage(imageWidth, imageWidth);
            Graphics2D targetGraphics = (Graphics2D)targetImage.getGraphics();
            try (Disposable d = targetGraphics::dispose;){
                targetGraphics.drawImage(image, blur, -(this.shadowSize / 2), -(this.shadowSize / 2));
            }
            int x = 1;
            int y = 1;
            int w = this.shadowSize;
            int h = this.shadowSize;
            images[Position.TOP_LEFT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = 1;
            y = h;
            w = this.shadowSize;
            h = 1;
            images[Position.LEFT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = 1;
            y = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images[Position.BOTTOM_LEFT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = this.cornerSize + 1;
            y = rectWidth;
            w = 1;
            h = this.shadowSize;
            images[Position.BOTTOM.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            y = x = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images[Position.BOTTOM_RIGHT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = rectWidth;
            y = this.cornerSize + 1;
            w = this.shadowSize;
            h = 1;
            images[Position.RIGHT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = rectWidth;
            y = 1;
            w = this.shadowSize;
            h = this.shadowSize;
            images[Position.TOP_RIGHT.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            x = this.shadowSize;
            y = 1;
            w = 1;
            h = this.shadowSize;
            images[Position.TOP.ordinal()] = this.getSubImage(targetImage, x, y, w, h);
            image.flush();
            CACHE.put(DropShadowBorder.getBorderHash(this.shadowSize, this.shadowOpacity, this.shadowColor), images);
        }
        return images;
    }

    private static int getBorderHash(int shadowSize, float opacity, Color shadowColor) {
        int result = shadowSize;
        result = 31 * result + (opacity != 0.0f ? Float.floatToIntBits(opacity) : 0);
        result = 31 * result + (shadowColor != null ? shadowColor.hashCode() : 0);
        return result;
    }

    private BufferedImage getSubImage(BufferedImage img, int x, int y, int w, int h) {
        return img.getSubimage(x, y, w, h);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int top = this.showTopShadow ? this.shadowSize : 0;
        int left = this.showLeftShadow ? this.shadowSize : 0;
        int bottom = this.showBottomShadow ? this.shadowSize : 0;
        int right = this.showRightShadow ? this.shadowSize : 0;
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public DropShadowBorder setShowTopShadow(boolean showTopShadow) {
        this.showTopShadow = showTopShadow;
        return this;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public DropShadowBorder setShowLeftShadow(boolean showLeftShadow) {
        this.showLeftShadow = showLeftShadow;
        return this;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public DropShadowBorder setShowRightShadow(boolean showRightShadow) {
        this.showRightShadow = showRightShadow;
        return this;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public DropShadowBorder setShowBottomShadow(boolean showBottomShadow) {
        this.showBottomShadow = showBottomShadow;
        return this;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public DropShadowBorder setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
        return this;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public DropShadowBorder setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
        if (shadowColor == null) {
            this.shadowColor = Color.BLACK;
        }
        return this;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public DropShadowBorder setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
        return this;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public DropShadowBorder setCornerSize(int cornerSize) {
        this.cornerSize = cornerSize;
        return this;
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;


        static int count() {
            return 8;
        }
    }
}

