/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.InsetsUIResource;

public class BubbleBorder
extends AbstractBorder {
    private final Insets insets;
    private Alignment pointerSide = Alignment.NORTH;
    private Color color;
    private int thickness;
    private int radius;
    private int pointerSize;
    private int pointerWidth;

    public BubbleBorder(Color color) {
        this(color, 1, 5, 5);
    }

    public BubbleBorder(Color color, int thickness, int radius, int pointerSize) {
        this.color = color;
        this.thickness = thickness;
        this.radius = radius;
        this.pointerSize = pointerSize;
        this.pointerWidth = pointerSize;
        this.insets = new InsetsUIResource(0, 0, 0, 0);
        this.setThickness(thickness);
    }

    public Color getColor() {
        return this.color;
    }

    public BubbleBorder setColor(Color color) {
        this.color = color;
        return this;
    }

    public int getPointerWidth() {
        return this.pointerWidth;
    }

    public BubbleBorder setPointerWidth(int pointerWidth) {
        this.pointerWidth = pointerWidth;
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public BubbleBorder setThickness(int n) {
        this.thickness = Math.max(n, 0);
        return this.setPointerSize(this.pointerSize);
    }

    public float getRadius() {
        return this.radius;
    }

    public BubbleBorder setPointerSize(int size) {
        this.pointerSize = Math.max(size, 0);
        int pSize = this.getPointerSide() != Alignment.CENTER ? this.pointerSize : 0;
        float left = this.thickness;
        float right = this.thickness;
        float bottom = this.thickness;
        float top = this.thickness;
        switch (this.pointerSide) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                top += (float)pSize;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                bottom += (float)pSize;
                break;
            }
            case WEST: {
                left += (float)pSize;
                break;
            }
            case EAST: {
                right += (float)pSize;
                break;
            }
        }
        this.insets.set((int)top, (int)left, (int)bottom, (int)right);
        return this;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public BubbleBorder setRadius(int radius) {
        this.radius = radius;
        return this.setPointerSize(this.pointerSize);
    }

    public Alignment getPointerSide() {
        return this.pointerSide;
    }

    public BubbleBorder setPointerSide(Alignment side) {
        this.pointerSide = side;
        this.setPointerSize(this.pointerSize);
        return this;
    }

    public float getOffset(float w, float h) {
        return (float)this.calculatePointerPad(w, h, Alignment.NORTH_WEST);
    }

    private double calculatePointerPad(float width, float height, Alignment side) {
        double pointerPad;
        switch (side) {
            case WEST: 
            case EAST: {
                pointerPad = (double)this.radius + (double)(height - (float)this.insets.top - (float)this.insets.bottom - (float)(2 * this.radius)) / 2.0;
                break;
            }
            case NORTH_WEST: 
            case SOUTH_WEST: {
                pointerPad = this.radius + this.insets.left + this.pointerWidth;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: {
                pointerPad = width - (float)this.radius - (float)this.insets.right - (float)this.pointerWidth;
                break;
            }
            case NORTH: 
            case SOUTH: {
                pointerPad = (double)this.radius + 0.5 * (double)(width - (float)this.insets.left - (float)this.insets.right - (float)(2 * this.radius));
                break;
            }
            default: {
                pointerPad = 0.0;
            }
        }
        return pointerPad;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Area area = this.getBorderArea(x, y, width, height);
        this.paintBorder(g, area);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    public Area getBubbleArea(float x, float y, float width, float height, float adj) {
        float w = width - 2.0f * adj;
        float h = height - 2.0f * adj;
        double pSize = (float)this.getPointerSize() - adj;
        double pWidth = (float)this.getPointerWidth() - 2.0f * adj;
        RoundRectangle2D.Float bubble = this.calculateBubbleRect(x + adj, y + adj, w, h);
        Area area = new Area(bubble);
        if (this.pointerSide != Alignment.CENTER) {
            double pointerPad = this.calculatePointerPad(w, h, this.pointerSide);
            switch (this.pointerSide) {
                case NORTH_EAST: 
                case SOUTH_EAST: {
                    pointerPad += (double)adj;
                    break;
                }
                case NORTH_WEST: 
                case SOUTH_WEST: {
                    pointerPad -= (double)adj;
                    break;
                }
            }
            Path2D pointer = this.creatPointerShape(pointerPad, pSize, pWidth, bubble);
            area.add(new Area(pointer));
        }
        return area;
    }

    public Area getBorderArea(int x, int y, int width, int height) {
        Area outer = this.getBubbleArea(x, y, width, height, 0.0f);
        Area inner = this.getBubbleArea(x, y, width, height, this.getThickness());
        outer.subtract(inner);
        return outer;
    }

    public void paintBorder(Graphics g, Area strokeArea) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        g2.setColor(this.color);
        g2.fill(strokeArea);
        config.restore();
    }

    public RoundRectangle2D.Float calculateBubbleRect(float x, float y, float width, float height) {
        return new RoundRectangle2D.Float(x + (float)this.insets.left, y + (float)this.insets.top, width - (float)this.insets.left - (float)this.insets.right, height - (float)this.insets.top - (float)this.insets.bottom, this.radius, this.radius);
    }

    private Path2D creatPointerShape(double pointerPad, double pSize, double pWidth, RoundRectangle2D.Float bubble) {
        double w = pWidth / 2.0;
        Path2D.Double pointer = new Path2D.Double(0);
        double x = bubble.x;
        double y = bubble.y;
        switch (this.pointerSide) {
            case WEST: {
                ((Path2D)pointer).moveTo(x, y + pointerPad - w);
                ((Path2D)pointer).lineTo(x - pSize, y + pointerPad);
                ((Path2D)pointer).lineTo(x, y + pointerPad + w);
                break;
            }
            case EAST: {
                ((Path2D)pointer).moveTo(x + (double)bubble.width, y + pointerPad - w);
                ((Path2D)pointer).lineTo(x + (double)bubble.width + pSize, y + pointerPad);
                ((Path2D)pointer).lineTo(x + (double)bubble.width, y + pointerPad + w);
                break;
            }
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                ((Path2D)pointer).moveTo(x + pointerPad - w, y);
                ((Path2D)pointer).lineTo(x + pointerPad, y - pSize);
                ((Path2D)pointer).lineTo(x + pointerPad + w, y);
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                ((Path2D)pointer).moveTo(x + pointerPad - w, y + (double)bubble.height);
                ((Path2D)pointer).lineTo(x + pointerPad, y + (double)bubble.height + pSize);
                ((Path2D)pointer).lineTo(x + pointerPad + w, y + (double)bubble.height);
                break;
            }
        }
        pointer.closePath();
        return pointer;
    }
}

