/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.LafInstaller;
import com.github.weisj.darklaf.components.renderer.SimpleListCellRenderer;
import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.settings.ThemeSettings;
import com.github.weisj.darklaf.synthesised.ThemedDarklafInfo;
import com.github.weisj.darklaf.task.DefaultsAdjustmentTask;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemeChangeListener;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.info.ThemeProvider;
import com.github.weisj.darklaf.theme.laf.ThemedLookAndFeel;
import com.github.weisj.darklaf.util.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public final class LafManager {
    private static final Logger LOGGER = LogUtil.getLogger(LafManager.class);
    private static final LafInstaller installer = new LafInstaller();
    private static ThemeProvider themeProvider;
    private static Theme theme;
    private static Theme installedTheme;
    private static final List<Theme> registeredThemes;
    private static final Collection<DefaultsAdjustmentTask> uiDefaultsTasks;
    private static final Collection<DefaultsInitTask> uiInitTasks;

    @Deprecated
    public static void enableLogging(boolean logEnabled) {
        LOGGER.warning("LafManger#enableLogging will overwrite specific log levels and is deprecated. Use LafManager#setLogLevel instead.");
        LafManager.setLogLevel(logEnabled ? Level.INFO : Level.SEVERE);
    }

    public static void setLogLevel(Level level) {
        LogUtil.setLevel(level);
        LOGGER.fine("Setting log level to " + level);
    }

    public static Level getLogLevel() {
        return LogUtil.getLevel();
    }

    public static boolean isDecorationsEnabled() {
        return DecorationsHandler.getSharedInstance().isCustomDecorationSupported();
    }

    public static void setDecorationsEnabled(boolean enabled) {
        boolean isEnabled = LafManager.isDecorationsEnabled();
        DecorationsHandler.getSharedInstance().setDecorationsEnabled(enabled);
        if (isEnabled != enabled && LafManager.isInstalled()) {
            LafManager.updateLaf();
        }
    }

    public static void enabledPreferenceChangeReporting(boolean enabled) {
        LOGGER.info("Preference reporting is set to: " + enabled);
        ThemePreferencesHandler.getSharedInstance().enablePreferenceChangeReporting(enabled);
        if (ThemeSettings.isInitialized()) {
            ThemeSettings.getInstance().setSystemPreferencesEnabled(enabled);
        }
    }

    public static boolean isPreferenceChangeReportingEnabled() {
        return ThemePreferencesHandler.getSharedInstance().isPreferenceChangeReportingEnabled();
    }

    public static void addThemePreferenceChangeListener(ThemePreferenceListener listener) {
        ThemePreferencesHandler.getSharedInstance().addThemePreferenceChangeListener(listener);
    }

    public static void removeThemePreferenceChangeListener(ThemePreferenceListener listener) {
        ThemePreferencesHandler.getSharedInstance().removeThemePreferenceChangeListener(listener);
    }

    public static void addThemeChangeListener(ThemeChangeListener listener) {
        installer.addThemeChangeListener(listener);
    }

    public static void removeThemeChangeListener(ThemeChangeListener listener) {
        installer.removeThemeChangeListener(listener);
    }

    public static PreferredThemeStyle getPreferredThemeStyle() {
        return ThemePreferencesHandler.getSharedInstance().getPreferredThemeStyle();
    }

    public static ThemeProvider getThemeProvider() {
        if (themeProvider == null) {
            themeProvider = LafManager.createDefaultThemeProvider();
        }
        return themeProvider;
    }

    public static void setThemeProvider(ThemeProvider themeProvider) {
        LafManager.themeProvider = themeProvider;
    }

    private static ThemeProvider createDefaultThemeProvider() {
        return ThemeProvider.createDefault();
    }

    public static Theme themeForPreferredStyle(PreferredThemeStyle style) {
        return LafManager.getThemeProvider().getTheme(style);
    }

    public static void registerTheme(Theme ... themes) {
        if (themes == null) {
            return;
        }
        for (Theme theme : themes) {
            LafManager.registerTheme(theme);
        }
    }

    public static void registerTheme(Theme theme) {
        registeredThemes.add(theme);
    }

    public static boolean unregisterTheme(Theme theme) {
        return registeredThemes.remove(theme);
    }

    public static Theme[] getRegisteredThemes() {
        Object[] themes = registeredThemes.toArray(new Theme[0]);
        Arrays.sort(themes);
        return themes;
    }

    public static UIManager.LookAndFeelInfo[] getRegisteredThemeInfos() {
        return (UIManager.LookAndFeelInfo[])registeredThemes.stream().sorted().map(ThemedDarklafInfo::new).filter(ThemedDarklafInfo::exists).toArray(UIManager.LookAndFeelInfo[]::new);
    }

    public static void replaceTheme(Theme oldTheme, Theme newTheme) {
        if (LafManager.unregisterTheme(oldTheme)) {
            LafManager.registerTheme(newTheme);
        }
    }

    public static ComboBoxModel<Theme> getThemeComboBoxModel() {
        return new DefaultComboBoxModel<Theme>(LafManager.getRegisteredThemes());
    }

    public static ListCellRenderer<Theme> getThemeListCellRenderer() {
        return SimpleListCellRenderer.create(Theme::getDisplayName);
    }

    public static Theme getTheme() {
        if (theme == null) {
            LafManager.setTheme(LafManager.themeForPreferredStyle(null));
        }
        return theme;
    }

    public static Theme getInstalledTheme() {
        return installedTheme != null ? installedTheme : LafManager.getTheme();
    }

    static void setInstalledTheme(Theme theme) {
        LOGGER.info("Setting installed theme: " + theme);
        installedTheme = theme;
    }

    public static boolean isInstalled() {
        return UIManager.getLookAndFeel() instanceof ThemedLookAndFeel;
    }

    public static void setTheme(Theme theme) {
        Theme old = LafManager.theme;
        LafManager.theme = theme;
        installer.notifyThemeChanged(old, theme);
        if (ThemeSettings.isInitialized()) {
            ThemeSettings.getInstance().refresh();
        }
    }

    public static void installTheme(ThemePreferenceChangeEvent changeEvent) {
        LafManager.setTheme(changeEvent.getPreferredThemeStyle());
        LafManager.install();
    }

    public static void installTheme(PreferredThemeStyle preferredThemeStyle) {
        LafManager.setTheme(preferredThemeStyle);
        LafManager.install();
    }

    public static void setTheme(PreferredThemeStyle preferredThemeStyle) {
        LafManager.setTheme(LafManager.themeForPreferredStyle(preferredThemeStyle));
    }

    public static void installTheme(Theme theme) {
        if (theme == LafManager.getTheme() && LafManager.isInstalled()) {
            return;
        }
        LafManager.setTheme(theme);
        LafManager.install();
    }

    public static void install(Theme theme) {
        LafManager.installTheme(theme);
    }

    public static void install() {
        Theme theme = LafManager.getTheme();
        installer.install(theme);
        LafManager.setInstalledTheme(theme);
    }

    public static void updateLaf() {
        installer.updateLaf();
    }

    public static void registerDefaultsAdjustmentTask(DefaultsAdjustmentTask task) {
        uiDefaultsTasks.add(task);
    }

    public static void removeDefaultsAdjustmentTask(DefaultsAdjustmentTask task) {
        uiDefaultsTasks.remove(task);
    }

    public static Collection<DefaultsAdjustmentTask> getUserDefaultsAdjustmentTasks() {
        return uiDefaultsTasks;
    }

    public static void registerInitTask(DefaultsInitTask task) {
        uiInitTasks.add(task);
    }

    public static void removeInitTask(DefaultsInitTask task) {
        uiInitTasks.remove(task);
    }

    public static Collection<DefaultsInitTask> getUserInitTasks() {
        return uiInitTasks;
    }

    public static Theme getClosestMatchForTheme(Theme theme) {
        if (theme == null) {
            return LafManager.themeForPreferredStyle(null);
        }
        for (Theme registered : LafManager.getRegisteredThemes()) {
            if (!registered.equals(theme)) continue;
            return registered;
        }
        for (Theme registered : LafManager.getRegisteredThemes()) {
            if (!registered.getThemeClass().equals(theme.getThemeClass())) continue;
            return registered;
        }
        return LafManager.themeForPreferredStyle(null);
    }

    static void notifyThemeInstalled() {
        installer.notifyThemeInstalled(LafManager.getTheme());
    }

    static {
        registeredThemes = new ArrayList<Theme>();
        uiDefaultsTasks = new ArrayList<DefaultsAdjustmentTask>();
        uiInitTasks = new ArrayList<DefaultsInitTask>();
        LafManager.setLogLevel(Level.WARNING);
        ServiceLoader.load(Theme.class).forEach(LafManager::registerTheme);
    }
}

