/*
 * Decompiled with CFR 0.152.
 */
package codes.egirl.notroinstaller;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Frame {
    public String home = System.getProperty("user.home") + File.separator + ".minecraft";
    private JFrame frame;
    private JLabel label;

    public Frame() {
        this.initialize();
        this.frame.setVisible(true);
    }

    private void initialize() {
        if (System.getProperty("os.name").contains("Windows")) {
            this.home = System.getenv("APPDATA") + File.separator + ".minecraft";
        } else if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.home = System.getProperty("user.home") + "/Library/Application Support/minecraft";
        }
        this.frame = new JFrame();
        this.frame.setSize(450, 200);
        ImageIcon imageIcon = new ImageIcon(Objects.requireNonNull(Frame.class.getClassLoader().getResource("dan.jpg")));
        this.frame.setIconImage(imageIcon.getImage());
        this.frame.setTitle("Notro Client Installer");
        this.frame.setDefaultCloseOperation(3);
        JButton button = new JButton("Install Client");
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Frame.this.install();
            }
        });
        button.setVisible(true);
        JButton closeButton = new JButton("Close Installer");
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Frame.this.frame.dispatchEvent(new WindowEvent(Frame.this.frame, 201));
            }
        });
        closeButton.setVisible(true);
        JPanel panel = new JPanel();
        panel.setVisible(true);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setVisible(true);
        this.label = new JLabel("Press install to install Notro Client!");
        this.label.setHorizontalAlignment(0);
        panel.add(this.label);
        buttonPanel.add((Component)button, "South");
        buttonPanel.add((Component)closeButton, "South");
        this.frame.add(panel);
        this.frame.add((Component)buttonPanel, "South");
    }

    public void install() {
        File notroVersionFolder = new File(this.home + File.separator + "versions" + File.separator + "NotroClient");
        if (!notroVersionFolder.exists()) {
            notroVersionFolder.mkdirs();
            System.out.println("[INSTALLER] Created Notro version folder.");
        }
        try {
            InputStream jsonInputStream = Frame.class.getClassLoader().getResourceAsStream("NotroClient.json");
            if (jsonInputStream != null) {
                this.saveFile(jsonInputStream, new File(notroVersionFolder, "NotroClient.json"));
            } else {
                System.err.println("InputStream was null.");
            }
            System.out.println("[INSTALLER] Installed json file to folder.");
        }
        catch (IOException var5) {
            var5.printStackTrace();
        }
        File libraryPath = new File(this.home + File.separator + "libraries" + File.separator + "me" + File.separator + "frosty" + File.separator + "notroclient");
        if (!libraryPath.exists()) {
            libraryPath.mkdirs();
            System.out.println("[INSTALLER] Created Notro library folder.");
        }
        try {
            InputStream jsonInputStream = Frame.class.getClassLoader().getResourceAsStream("frosty-notroclient.jar");
            if (jsonInputStream != null) {
                this.saveFile(jsonInputStream, new File(libraryPath, "frosty-notroclient.jar"));
            } else {
                System.err.println("InputStream was null.");
            }
            System.out.println("[INSTALLER] Installed jar file to folder.");
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        this.label.setText("Install complete. You may close the installer.");
    }

    public void saveFile(InputStream in, File file) throws IOException {
        Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

